package tests::ChartTypesVBarsTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::ChartTypes::VBars;
use Lire::Config::Build qw/ac_info/;
use Lire::Config::ChartSpec;
use Lire::Config::ExecutableSpec;
use Lire::PluginManager;
use Lire::ReportParser::ReportBuilder;
use Lire::Utils qw/tempdir/;

use File::Basename qw/dirname/;
use IO::Scalar;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'cfg'}{'ploticus_path'} =
      new Lire::Config::ExecutableSpec( 'name' => 'ploticus_path' )->instance( 'value' => ac_info( 'PLOTICUS' ) );
    $self->{'cfg'}{'lr_chart_font'} = '';
    $self->{'chart_cfg'} = new Lire::Config::ChartSpec( 'name' => 'chart' )->instance();

    return;
}

sub create_plugin {
    return new Lire::ChartTypes::VBars();
}

sub properties_spec_file {
    return dirname( __FILE__ ) . "/../Lire/ChartTypes/ct_vbars.xml";
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/ChartTypes/ct_vbars_init";
}

sub set_up_subreport {
    my $self = $_[0];

    my $parser = new Lire::ReportParser::ReportBuilder();
    my $report = $parser->parsefile( dirname( __FILE__ ) . "/data/test-sqlite.xml" );
    $self->{'subreport'} = $report->subreport_by_id( 'top-files.0' );
}

sub test_get_vars {
    my $self = $_[0];

    $self->set_up_subreport();
    $self->test_registration_file();
    my $vbars = Lire::PluginManager->get_plugin( 'chart_type', 'vbars' );

    my $info = $self->{'subreport'}->table_info();
    $info->set_variables_indices();

    $self->{'chart_cfg'}->type( $vbars );;
    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );

    my $props = $self->{'chart_cfg'}->get( 'type' )->get_properties();
    $props->get( 'y' )->set( 'request_total' );
    $self->assert_deep_equals( [$info->column_info_by_name( 'request_total' )],
                               $vbars->get_vars( $self->{'chart_cfg'} ) );
    $props->get( 'y2' )->set( 'request_ratio' );
    $self->assert_deep_equals( [$info->column_info_by_name( 'request_total' ),
                                $info->column_info_by_name( 'request_ratio' )],
                               $vbars->get_vars( $self->{'chart_cfg'}  ) );
}

sub test_write_parameters {
    my $self = $_[0];

    $self->set_up_subreport();
    my $fh = new IO::Scalar();
    my $buf = $fh->sref();
    $self->test_registration_file();
    my $info = $self->{'subreport'}->table_info();
    $info->set_variables_indices();
    my $vbars = Lire::PluginManager->get_plugin( 'chart_type', 'vbars' );
    $self->{'chart_cfg'}->type( $vbars );
    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );

    my $props = $self->{'chart_cfg'}->get( 'type' )->get_properties();
    $props->get( 'y' )->set( 'request_total' );
    $vbars->write_parameters( $self->{'chart_cfg'}, $fh );
    my @lines = split /\n/, $$buf;
    $self->assert_str_equals( '#set x = 1', $lines[0] );
    $self->assert_str_equals( '#set stubvert = yes', $lines[-4] );
    $self->assert_str_equals( '#set barwidth = 0.05', $lines[-3] );
    $self->assert_str_equals( '#set sep = 0.08', $lines[-2] );
    $self->assert_str_equals( '#set y = 2', $lines[-1] );

    $$buf = '';
    $props->get( 'y2' )->set( 'request_ratio' );
    $props->get( 'numbers' )->set( 1 );
    $vbars->write_parameters( $self->{'chart_cfg'}, $fh );
    @lines = split /\n/, $$buf;
    $self->assert_str_equals( '#set y = 2', $lines[-3] );
    $self->assert_str_equals( '#set y2 = 3', $lines[-2] );
    $self->assert_str_equals( '#set vals = yes', $lines[-1] );
}

sub test_write_chart {
    my $self = $_[0];

    $self->set_up_subreport();
    my $keep = $ENV{'KEEP_CHART'} || 0;
    $self->test_registration_file();
    my $vbars = Lire::PluginManager->get_plugin( 'chart_type', 'vbars' );

    $self->{'chart_cfg'}->basename( 'vbars' );
    $self->{'chart_cfg'}->title( $self->{'subreport'}->title() );
    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );
    $self->{'chart_cfg'}->type( $vbars );
    $self->{'chart_cfg'}->xlabel( 'Files' );

    my $props = $self->{'chart_cfg'}->get( 'type' )->get_properties();
    $props->get( 'y' )->set( 'request_total' );
    $props->get( 'y2' )->set( 'request_ratio' );
    $props->get( 'numbers' )->set( 1 );

    my $dir = tempdir( $self->name() . '_XXXXXX', CLEANUP => !$keep );
    my $chart = $vbars->write_chart( $self->{'chart_cfg'},
                                     $self->{'subreport'},
                                     'outputdir' => $dir, 'format' => 'png' );
    $self->assert( -f $chart ? 1 : 0, "file '$chart' not created" );
    warn( "\nChart written in: $chart\n"  )
      if $keep;
}


1;
