/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include "p2open.h"

static int	pids[NOFILE];

int
p2open(char *interp, char *cmd, FILE *fp[2])
{
	int	sock[2];
	pid_t	pid;
	int	rc;

	rc = socketpair(AF_UNIX, SOCK_STREAM, 0, sock);
	if (rc < 0)
		return -1;

	pid = fork();
	if (pid == 0)
	{
		close(0);
		close(1);
		dup2(sock[0], 0);
		dup2(sock[0], 1);
		close(sock[0]);
		close(sock[1]);

		if (!interp)
			interp = "/bin/sh";
		execl(interp, "sh", "-c", cmd, 0);
		exit(1);
	}

	if (pid == -1)
	{
		close(sock[0]);
		close(sock[1]);
		return -2;
	}

	pids[sock[1]] = pid;

	fp[0] = fdopen(sock[1], "r");
	fp[1] = fdopen(sock[1], "w");

	close(sock[0]);

	return (0);
}

int
p2close(FILE *fp[2])
{
	int		fd;
	int		rc;
	int		status;
	typedef		void (*sighandler_t)(int);
	sighandler_t	isig, qsig, hsig;

	if (!fp[0])
	    return -1;

	fd = fileno(fp[0]);
	fclose(fp[0]);

	isig = signal(SIGINT, SIG_IGN);
	qsig = signal(SIGQUIT, SIG_IGN);
	hsig = signal(SIGHUP, SIG_IGN);

	rc = waitpid(pids[fd], &status, 0);
	if (rc == -1)
		status = -1;

	signal(SIGINT, isig);
	signal(SIGQUIT, qsig);
	signal(SIGHUP, hsig);

	return (status);
}

int
p2kill(FILE *fp[2])
{
	int		fd;
	int		rc;
	int		status;
	typedef		void (*sighandler_t)(int);
	sighandler_t	isig, qsig, hsig;

	if (!fp[0])
	    return -1;

	fd = fileno(fp[0]);
	fclose(fp[0]);
	kill(pids[fd], SIGTERM);

	isig = signal(SIGINT, SIG_IGN);
	qsig = signal(SIGQUIT, SIG_IGN);
	hsig = signal(SIGHUP, SIG_IGN);

	rc = waitpid(pids[fd], &status, 0);
	if (rc == -1)
		status = -1;

	signal(SIGINT, isig);
	signal(SIGQUIT, qsig);
	signal(SIGHUP, hsig);

	return (status);
}
