#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "global_vars.h"
#include "lists.h"

int validate_ip(char ipl_type, struct list_anchor_t* ipl_list, struct sockaddr_in *from)
// ret 0 if from.sin_addr.s_addr is ok, else -1
{
 int res = -1;
 struct ipl_item_t *ipe = (struct ipl_item_t *)ipl_list->first;
 if ( ipl_type == IPL_INVALID ) return(-1);
 if ( !ipl_list->count ) return(-1); // if list is empty
 while ( (res == -1) && ( ipe != NULL ) )
 {
     switch (ipe->type)
     {
         case IPL_MASK:
	     if ( (from->sin_addr.s_addr & ipe->ipb) ==
	          (ipe->ipa & ipe->ipb) ) res = 0;
	     break;
	 case IPL_RANGE:
	     if ( (ntohl(from->sin_addr.s_addr) >= ntohl(ipe->ipa)) &&
	          (ntohl(from->sin_addr.s_addr) <= ntohl(ipe->ipb)) ) res = 0;
	     break;
     }
     ipe = (struct ipl_item_t*)ipe->next;
 }
 switch (ipl_type)
 {
     case IPL_ALLOW:
         if ( res == 0 ) return(0);
	 break;
     case IPL_DENY:
         if ( res == -1 ) return(0);
         break;
 }
 return(-1); // DISALLOW ACCESS
}
