//
// simple_quoter_server.cpp
//
// implementation of a simple stock quote server.
//
//

#include <string>
#include <sstream>
#include "xmlrpc.hpp"

class simple_quoter_server : public xmlrpc::server
{
public:
  simple_quoter_server ( int port ) :
    xmlrpc::server ( port ) {}
  ~simple_quoter_server (){}

  virtual xmlrpc::reply handle_request ( const xmlrpc::request& request )
  {
    xmlrpc::reply reply;

    if ( request.get_name() == "get_quote" )
      {
	try
	  {
	    xmlrpc::param ticker = request.get_param ( "ticker" );
	    if ( ticker.get_value() == "RHAT" )
	      {
		reply.set_value ( "5.07" );
	      }
	    else
	      {
		reply.add_error ( "Invalid ticker." );
	      }
	  }
	catch ( xmlrpc::exception& e )
	  {
	    reply.add_error ( "Request was not formatted properly." );
	  }
      }
    else
      {
	reply.add_error ( "Invalid request name." );
      }
    return reply;
  }
};


int main ( int argc, int argv[] )
{
  simple_quoter_server server ( 31000 );

  try
    { server.run(); }
  catch ( xmlrpc::exception& e )
    {
      std::cout << "Exception caught while running the server:\n"
		<< e.description() << "\nExiting.\n";
    }
  return 0;
}
