//
// simple_quoter_client.cpp
//
// implementation of a simple stock quote client.
//
//

#include <string>
#include <sstream>
#include "xmlrpc.hpp"


int main ( int argc, int argv[] )
{
  xmlrpc::client client ( "localhost", 31000 );

  xmlrpc::request request ( "get_quote" );
  request.add_param ( xmlrpc::param ( "ticker", "RHAT" ) );

  try
    {
      for ( int i = 0; i < 10; i++ )
	{
	  xmlrpc::reply reply = client.send_request ( request );

	  if ( ! reply.get_error_count() )
	    {
	      std::cout << "The quote for 'RHAT' is "
			<< reply.get_value() << "\n";
	    }
	  else
	    {
	      for ( int i = 0; i < reply.get_error_count(); i++ )
		{
		  std::cout << reply.get_error ( i ) << "\n";
		}
	    }
	}
    }
  catch ( xmlrpc::exception& e )
    { std::cout << "exception caught: " << e.description() << "\n"; }

  return 0;
}
