//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


#ifndef _xmlrpc_server_class_
#define _xmlrpc_server_class_


#include "request.hpp"
#include "reply.hpp"

namespace xmlrpc
{
  //
  // Derive from this, override the
  // handle_request() method, and
  // call run().
  //
  class server
  {
  public:
    server ( const int port );
    virtual ~server();

    //
    // should be overridden
    //
    virtual reply handle_request ( const request& r ) = 0;

    //
    // Call this to start accepting connections
    //
    void run();


  private:
    int m_port, m_threads;
  };

};



#endif
