/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgicon.h"

#include <qimage.h>
#include <qbitmap.h>
#include <qwmatrix.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <kpixmapeffect.h>
#include <kpixmapio.h>
#include <kpixmap.h>
#include <kimageeffect.h>
#include <qdrawutil.h> 
#include <kstandarddirs.h>
#include <qfile.h>
#include <qpainter.h>
#include <qfontmetrics.h> 

#include "xeplugin_gapplet.h"

#include <kxdocker_setup_sources.h>

#include <xeplugin_gepillow.h>

//#undef ENABLE_FINAL

XSConfigurations * XGIcon::ActiveConfiguration;

XGIcon::XGIcon(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	xPillow=NULL;
	xAndZoomCache=0; 	// by default i will not use cache
	xExclude=0;		// its always showed
	
	
	/*
	xPillow=new XEPlugin_GEPillow(0,0);
	
	xPillow->resize(300,30);
	xPillow->move(0,0);
	xPillow->show();
	*/
	/*
	xPillow->xSetup();
	xPillow->xStart();
	xPillow->move(0,0);
	*/
}


XGIcon::~XGIcon()
{
}


#include "xgicon.moc"


/*!
    \fn XGIcon::xLoadIcon(const QString &)
 */
void XGIcon::xLoadIcon(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetZoom(int,int)
 */
void XGIcon::xSetZoom(int newZoomX,int newZoomY)
{
	if(newZoomX==newZoomY)
	{
		xSetZoom(newZoomX);
	}
	else
	{
		// Ok we have to enable the double zoom
		xZoom=-1;
		xZoomX=newZoomX;
		xZoomY=newZoomY;
		xSetUpdate=1;
	}
}

/*!
    \fn XGIcon::xSetZoom(int)
 */
void XGIcon::xSetZoom(int newZoom)
{
	if(newZoom==xZoom)return;
	xZoom=newZoom;
	
	if(xImgCachedZoom[xZoom]>0)
	{
			xImgShowed=xImgCached[xZoom];
			xSetUpdate=xImgCachedZoom[xZoom];
			/*
			char errore[50];
			sprintf(errore,"Cache: (%d)",xZoom);
			qWarning(errore);
			*/
			return;
			
	}
	
	// Perfomance test QImage::ScaleMin is not good
	//xImgShowed=xImgSource.scale(xZoom,xZoom,QImage::ScaleMin);
	xImgShowed=xImgSource.scale(xZoom,xZoom);
	if(xZoom & xAndZoomCache)
	{
		xImgCached[xZoom]=xImgShowed;
		xImgCachedZoom[xZoom]=1;
	}
	xSetUpdate=1;
}


/*!
    \fn XGIcon::xSetHotSpot(const QPoint &)
 */
void XGIcon::xSetHotspot(const QPoint &newPoint)
{
	xHotspot=newPoint;
}


/*!
    \fn XGIcon::xReset()
 */
void XGIcon::xReset()
{
	// Will reset ALL DATA!!!!!
	// do this at startup or when you have to clear this icon
	
	cachePurge();	
	xHotspot.setX(0);
	xHotspot.setY(0);
	xImgShowed.reset();
	xImgSource.reset();
	xPosDefault.setX(0);
	xPosDefault.setY(0);
	xPosition.setX(0);
	xPosition.setY(0);
	xSetUpdate=0;
	xTransparency.resize(0,0);
	xZoom=-1;
	xZoomY=-1;
	xZoomX=-1;
}


/*!
    \fn XGIcon::xSetImage(const QString &)
 */
void XGIcon::xSetImage(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetImage(const QPixmap &)
 */
void XGIcon::xSetImage(const QPixmap &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xRepeat(int rWidth,int rHeight)
 */
void XGIcon::xRepeat(int rWidth,int rHeight)
{
#ifdef HAS_KDE31
	xImgSource=xImgSource.smoothScale(rWidth,rHeight);
#else
	KPixmapIO kImgConverter;
	KPixmap pTiled=kImgConverter.convertToPixmap(xImgSource);
	pTiled=KPixmapEffect::createTiled(pTiled,QSize(rWidth,rHeight));
	xImgSource=kImgConverter.convertToImage(pTiled);
	xZoom=-1;
	xZoomY=-1;
	xZoomX=-1;
#endif
}


/*!
    \fn XGIcon::xSetIntensity(float)
 */
void XGIcon::xSetIntensity(float ratio)
{
	if(xImgCachedZoom[xZoom]<3)
	{
		xImgShowed=KImageEffect::intensity(xImgShowed, ratio);
		xImgCachedZoom[xZoom]=3;
	}
}


/*!
    \fn XGIcon::xResetIntensity()
 */
void XGIcon::xResetIntensity()
{
		xImgShowed=KImageEffect::intensity(xImgShowed,100);
		xImgCachedZoom[xZoom]=0;
}


/*!
    \fn XGIcon::xSetSmoothZoom(int)
 */
void XGIcon::xSetSmoothZoom(int newZoom)
{
	xZoom=newZoom;
	if(xImgCachedZoom[xZoom]<2)
	{
		xImgShowed=xImgSource.smoothScale(xZoom,xZoom);//,QImage::ScaleMin);
		xImgCached[xZoom]=xImgShowed;
		xImgCachedZoom[xZoom]=2;
		return;
	}
	xImgShowed=xImgCached[xZoom];
}


/*!
    \fn XGIcon::cachePurge()
 */
void XGIcon::cachePurge()
{
	/*
	for(int i=0;i<MAX_CACHE_ICONS;i++)
	{
		xImgCachedZoom[i]=0;
		xImgCached[i].reset();
	}
	*/
	memset(xImgCachedZoom,0 , MAX_CACHE_ICONS*sizeof(int));
}


/*!
    \fn XGIcon::xSetClass(QObject *)
 */
void XGIcon::xSetClass(QObject *newClassManager)
{
	xClassManager=newClassManager;
	connect(this,SIGNAL(xAttach(QObject *)),newClassManager,SLOT(xAttach(QObject *)));
	//XEPlugin_GApplet *GApplet=(XEPlugin_GApplet *)xClassManager;
	//GApplet->xAttach(this);
	xAttach(this);
}


/*!
    \fn XGIcon::xSetText(const QString &)
 */
void XGIcon::xSetText(const QString &newText)
{
	pillowText=newText;
	isTextDrawed=0;
}


/*!
    \fn XGIcon::xGetFontHeight()
 */
int XGIcon::xGetFontHeight()
{
	QFont	overTextFont;
	
	overTextFont.setFamily(ActiveConfiguration->Icons.FontFamily);
	overTextFont.setPointSize(ActiveConfiguration->Icons.FontSize);
	
	QFontMetrics fm( overTextFont);
	
//	int pixelsWide = fm.width("test")+10;
	int pixelsHigh = fm.height();
	return pixelsHigh;
}


/*!
    \fn XGIcon::xGetImage(QImage *&)
 */
void XGIcon::xGetImage(QImage *&pluginimg)
{
    pluginimg=&xImgSource;
}


/*!
    \fn XGIcon::xSetSmoothZoom()
 */
void XGIcon::xSetSmoothZoom()
{
	int oldZoom=xZoom;
	xImgCachedZoom[xZoom]=0;
	xZoom=0;
	xSetSmoothZoom(oldZoom);
}


/*!
    \fn XGIcon::xGetConfiguration(XSGObjectIcon *&)
 */
void XGIcon::xGetConfiguration(const XSGObjectIcon *&a)
{
	a=iconConfiguration;
}


/*!
    \fn XGIcon::xGetPluginConfiguration(QDomNodeList *&)
 */
void XGIcon::xGetPluginConfiguration(const QDomNodeList *&a)
{
    	a=&iconConfiguration->PluginConfiguration;
}




/*!
    \fn XGIcon::xRedraw()
 */
void XGIcon::xRedraw()
{
    xRefresh(this);
}


/*!
    \fn XGIcon::xDrawText()
 */
void XGIcon::xDrawText()
{
	// this will create a QImage image to draw the text on the screen
	
	// reset the text image (free memory)
	/*
	xImgText.reset();
	
	// valid string?
	if(pillowText.length()<1)
	{
		return;
	}
	isTextDrawed=1;
	// Var
	// draw
	QPainter Pencil;
	QFont	overTextFont;
	QPixmap	overTextBuffer;
	QColor	overTextColor;
	
	// load how to draw
	overTextFont.setFamily(ActiveConfiguration->Icons.FontFamily);
	overTextColor.setRgb(
		ActiveConfiguration->Icons.FontRed,
		ActiveConfiguration->Icons.FontGreen,
		ActiveConfiguration->Icons.FontBlue
		);
	overTextFont.setPointSize(ActiveConfiguration->Icons.FontSize);
	
	// get the pillow image
	QString CuscinoName=ActiveConfiguration->Theme.PillowPath;
	
	// TODO: any icon can have a pillow
	CuscinoName=CuscinoName+"/pillow.png";
	// find resources
	QFile a(::locate("data",CuscinoName));
	if(!a.exists() || CuscinoName==QString::null)
	{
		CuscinoName="kxdocker/themes/pillow/default/pillow.png";
	}
#ifndef ENABLE_FINAL
	qWarning(CuscinoName);
	qWarning(::locate("data",CuscinoName));
#endif
	
	// load base image pillow
	overTextBuffer.load(::locate("data",CuscinoName));
	// starting draw the text
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:291");
#endif
	// if it's null: we cannot load the pillow image
	if(overTextBuffer.isNull())
	{
		// 
		QImage TBuffer;
		// we cannot load the pillow than we create a fully transparent image
		TBuffer.create(
			200,
			30,
			32);
		TBuffer.setAlphaBuffer(false);
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		overTextBuffer.convertFromImage(TBuffer);
		overTextBuffer.detach();
#ifndef ENABLE_FINAL
		qWarning("xgicon.cpp:304");
#endif
	}
	
	// starting draw the text on the pillow
	Pencil.begin(&overTextBuffer);
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:308");
#endif
	// load up the font
	Pencil.setFont(overTextFont);
	// text align
	QRect overTextRect;
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:311");
#endif
	// the rectangle of text
	QFontMetrics fm( overTextFont);
	int pixelsWide = fm.width( pillowText )+10;
	int pixelsHigh = fm.height();
  
	overTextRect.setLeft(0);
	overTextRect.setRight(pixelsWide);
	overTextRect.setTop(0);
	overTextRect.setBottom(pixelsHigh);
	QRect rTesto=Pencil.boundingRect(overTextRect,Qt::AlignHCenter,pillowText);
	// Ok got the right rect
	Pencil.end();
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:321");
#endif		
	// devo fare lo scale dell'immagine
	xImgText=overTextBuffer.convertToImage();
	if(overTextBuffer.isNull())qWarning("overTextBuffer.isNull()");
	if(xImgText.isNull())qWarning("xImgText.isNull()");
	
	xImgText=xImgText.smoothScale(
				rTesto.right()+rTesto.left(),
				rTesto.bottom()+rTesto.top()+2);
	
	if(xImgText.isNull())qWarning("xImgText.isNull() 2");

	overTextBuffer.convertFromImage(xImgText);
	// end scale
		
	xTextDecentre=(ActiveConfiguration->Icons.SizeBig-
			rTesto.right()-rTesto.left())/2;
		
		overTextRect.setLeft(0);
		overTextRect.setRight(pixelsWide);
		overTextRect.setTop(0);
		overTextRect.setBottom(pixelsHigh);
		
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:340");
#endif
		// starting drawing the text
	Pencil.begin(&overTextBuffer);
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:343");
#endif
		Pencil.setFont(overTextFont);

		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
			pillowText
			);
		overTextRect.setTop(1);
		overTextRect.setRight(pixelsWide+1);
		Pencil.setPen(overTextColor);
		
		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
			pillowText);
	Pencil.end();
#ifndef ENABLE_FINAL
	qWarning("xgicon.cpp:356");
#endif
	
	xImgText=overTextBuffer.convertToImage();
	//xImgText=overTextBuffer;
	*/
	
	xImgText.resize(0,0);
	
	// (martind@pirack.com) This avoids the big red box when no text is assigned to the OverText
  QPixmap	overTextBuffer;
  QBitmap	overTextMask;
	
	overTextBuffer.resize(800,30);
	overTextMask.resize(800,30);
	//overTextBuffer.fill(Qt::color0);
	overTextBuffer.fill(Qt::white);
	overTextMask.fill(Qt::color0);
	
	if(pillowText.length())
	{
  	isTextDrawed=1;
  	QPainter Pencil;
  	QFont	overTextFont;
  	QColor	overTextColor;
  	
  	
  	// load how to draw
  	overTextFont.setFamily(ActiveConfiguration->Icons.FontFamily);
  	overTextColor.setRgb(
  		ActiveConfiguration->Icons.FontRed,
  		ActiveConfiguration->Icons.FontGreen,
  		ActiveConfiguration->Icons.FontBlue
  		);
  	overTextFont.setPointSize(ActiveConfiguration->Icons.FontSize);
  
  	
  	
  	// starting draw the text on the pillow
  	Pencil.begin(&overTextBuffer);
  	// load up the font
  	Pencil.setFont(overTextFont);
  	// text align
  	QRect overTextRect;
  	// the rectangle of text
  	QFontMetrics fm( overTextFont);
  	int pixelsWide = fm.width( pillowText )+10;
  	int pixelsHigh = fm.height();
    
  	overTextRect.setLeft(0);
  	overTextRect.setRight(pixelsWide);
  	overTextRect.setTop(0);
  	overTextRect.setBottom(pixelsHigh);
  	QRect rTesto=Pencil.boundingRect(overTextRect,Qt::AlignHCenter,pillowText);
  	// Ok got the right rect
  	Pencil.end();
  	// devo fare lo scale dell'immagine		
  	xTextDecentre=(ActiveConfiguration->Icons.SizeBig-
  			rTesto.right()-rTesto.left())/2;
  		
  		overTextRect.setLeft(0);
  		overTextRect.setRight(pixelsWide);
  		overTextRect.setTop(0);
  		overTextRect.setBottom(pixelsHigh);
  		// starting drawing the text
  	Pencil.begin(&overTextBuffer);
  		Pencil.setFont(overTextFont);
  
  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText
  			);
  		overTextRect.setTop(1);
  		overTextRect.setRight(pixelsWide+1);
  		Pencil.setPen(overTextColor);
  		
  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText);
  	Pencil.end();
  	
  	Pencil.begin(&overTextMask);
  		Pencil.setFont(overTextFont);
  		Pencil.setPen(Qt::color1);
  
  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText
  			);
  		overTextRect.setTop(1);
  		overTextRect.setRight(pixelsWide+1);
  		
  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText);
  	Pencil.end();
	}
  	
 	//overTextMask=overTextBuffer;
 	overTextBuffer.setMask(overTextMask);
	//bitBlt(&overTextMask,0,0,&overTextBuffer,Qt::CopyROP);
	xImgText=overTextBuffer;
}


/*!
    \fn XGIcon::xSetZoom()
 */
void XGIcon::xSetZoom()
{
	int oldZoom=xZoom;
	xImgCachedZoom[xZoom]=0;
	xZoom=0;
	xSetZoom(oldZoom);
}


/*!
    \fn XGIcon::xStartAnimating()
 */
void XGIcon::xStartAnimating()
{
	xEventStartAnimating();
}


/*!
    \fn XGIcon::xStopAnimating()
 */
void XGIcon::xStopAnimating()
{
    xEventStopAnimating();
}


/*!
    \fn XGIcon::createPopup()
 */
void XGIcon::createPopup()
{
	// TODO: make XEConfiguration more complex!!!!!!!!
	// by moving this functions to it
	//iconConfiguration->PluginPopupMenu=new KPopupMenu();
	
}


/*!
    \fn XGIcon::getPopupMenu(KPopupMenu *&)
 */
void XGIcon::getPopupMenu(KPopupMenu *&)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xStartClass()
 */
void XGIcon::xStartClass()
{
    // emit signal
    xStart();
}


/*!
    \fn XGIcon::xSetupClass()
 */
void XGIcon::xSetupClass()
{
    // emit signal
    xSetup();
}
