#ifndef _KVI_EDITOR_SYNTAXHIGHLIGHTER_H_INCLUDED_
#define _KVI_EDITOR_SYNTAXHIGHLIGHTER_H_INCLUDED_

// =============================================================================
//
//      --- kvi_editor_syntaxhighlighter.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qcolor.h>
#include <qfont.h>
#include <qsyntaxhighlighter.h>

typedef struct KviEditorColors
{
	QColor background;
	QColor extBackground;
	QColor normalText;
	QColor cursor;

	QFont  font;

	QColor cppBackground;
	QColor cppExtBackground;
	QColor cppNormalText;
	QColor cppCursor;
	QColor cppBrace;
	QColor cppLineComment;
	QColor cppMultilineComment;
	QColor cppParenthesis;
	QColor cppOperator;
	QColor cppEscape;
	QColor cppChar;
	QColor cppString;
	QColor cppKeyword;
	QColor cppType;
	QColor cppNumber;
	QColor cppPunctuation;
	QColor cppSystemIdentifier;
	QColor cppPreprocessor;
	QColor cppInclude;
	QColor cppMemberVariable;
	QColor cppGlobalVariable;
	QColor cppQClass;
	QColor cppQSignals;

	QColor cppKClass;
	QColor cppXStuff;
	QColor cppGtkStruct;
	QColor cppGdkStruct;
	QColor cppGType;
	QColor cppGtkCall;
	QColor cppGdkCall;
	QColor cppGtkMacro;
	QColor cppGdkMacro;
	QColor cppGMacro;

	QFont  cppFont;

	QColor cppSpecial;

	QColor htmlBackground;
	QColor htmlExtBackground;
	QColor htmlNormalText;
	QColor htmlCursor;
	QColor htmlComment;
	QColor htmlTag;
	QColor htmlString;
	QColor htmlTagInternal;

	QFont htmlFont;
};

class KviEditorSyntaxHighlighter : public QSyntaxHighlighter
{
public:
	KviEditorSyntaxHighlighter(QTextEdit *);
	~KviEditorSyntaxHighlighter();

	enum ColorMode { Normal, CPP, HTML };

	void setMode(ColorMode mode);
	ColorMode mode();
public slots:
	void switchMode();
protected:
	void initializeCurrentMode();

	virtual int       highlightParagraph(const QString &, int);
	virtual int highlightParagraphNormal(const QString &, int);
	virtual int    highlightParagraphCPP(const QString &, int);
	virtual int   highlightParagraphHTML(const QString &, int);

	QColor *cppModeGetTokenColor(const QString &);

	KviEditorColors *m_pColors;
	ColorMode        m_mode;
};

#endif // _KVI_EDITOR_SYNTAXHIGHLIGHTER_H_INCLUDED_
