#ifndef _KVI_POPUPLISTVIEW_H_INCLUDED_
#define _KVI_POPUPLISTVIEW_H_INCLUDED_

// =============================================================================
//
//      --- kvi_popuplistview.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_listview.h"
#include "kvi_string.h"

typedef struct _KviPopupClipboardItem KviPopupClipboardItem;

class KviPopupListViewItem : public KviListViewItem
{
public:
	enum PopupItemType { Submenu, Separator, Item };

	KviPopupListViewItem(
		PopupItemType, KviPopupListViewItem *parent,
		const char *name, const char *type, const char *buffer = 0, const char *icon = 0
	);
	KviPopupListViewItem(
		PopupItemType, KviPopupListViewItem *parent, KviPopupListViewItem *after,
		const char *name, const char *type, const char *buffer = 0, const char *icon = 0
	);
	KviPopupListViewItem(
		PopupItemType, KviListView *parent,
		const char *name, const char *type, const char *buffer = 0, const char *icon = 0
	);
	KviPopupListViewItem(
		PopupItemType, KviListView *parent, KviPopupListViewItem *after,
		const char *name, const char *type, const char *buffer = 0, const char *icon = 0
	);
	~KviPopupListViewItem();
public:
	KviStr        m_buffer;
	KviStr        m_icon;
	PopupItemType m_type;
	int           m_id;
public:
	void tryLoadImage();
	KviPopupClipboardItem *getClipboardItem();
};

typedef struct _KviPopupClipboardItem
{
	KviStr szName;
	KviStr szBuffer;
	KviStr szIcon;

	KviPopupListViewItem::PopupItemType  type;
	QPtrList<_KviPopupClipboardItem>    *pItemList;
} KviPopupClipboardItem;

#endif // _KVI_POPUPLISTVIEW_H_INCLUDED_
