#ifndef _KVI_SERVERDIALOG_H_INCLUDED_
#define _KVI_SERVERDIALOG_H_INCLUDED_

// =============================================================================
//
//      --- kvi_serverdialog.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_tabdialog.h"

class KviComboBox;
class KviFieldEditor;
class KviFrame;
class KviIrcProxyListItem;
class KviIrcProxyManager;
class KviIrcServerListItem;
class KviIrcServerManager;
class KviListView;
class KviListViewItem;
class KviPushButton;

class KviServerDialog : public KviTabDialog
{
	friend class KviFrame;

	Q_OBJECT
public:
	KviServerDialog(QWidget *parent);
	~KviServerDialog();

	KviFrame *m_pFrm;
signals:
	void finished(bool bAccepted);
protected slots:
	virtual void done(int);
	virtual void closeEvent(QCloseEvent *);
	void currentNetworkChanged(const QString &);
	void currentServerChanged(KviListViewItem *);
	void  currentProxyChanged(KviListViewItem *);
	void  serverDoubleClicked(KviListViewItem *);
	void   proxyDoubleClicked(KviListViewItem *);
	void deleteNetwork();
	void newNetwork();
	void deleteServer();
	void newProxy();
	void editProxy();
	void deleteProxy();
	void newServer();
	void editServer();
	void sortServers();
	void importFromIni();
	void serverEditFinished(const QString &text);
	void  proxyEditFinished(const QString &text);
protected:
	virtual bool eventFilter(QObject *, QEvent *);
private:
	enum KviOptDlgServerField { Host, Port, Description, Password, IP, IPv6 };
	enum KviOptDlgProxyField  { ProxyHost, ProxyPort, ProxyUsername, ProxyPassword, ProxyIP };

	void fillNetCombo();
	void fillServerList(KviIrcNetwork *);
	void fillProxyList();
	void enableServerButtons(bool bEnable);
	void enableProxyButtons(bool bEnable);
	void editServerField(KviIrcServerListItem *, KviOptDlgServerField);
	void editProxyField(KviIrcProxyListItem *, KviOptDlgProxyField);
	bool updateNetworkName();

	KviIrcServerManager     *m_pManager;
	KviIrcProxyManager      *m_pProxyManager;
	KviComboBox             *m_pNetCombo;
	KviListView             *m_pServerList;
	KviListView             *m_pProxyList;
	KviPushButton           *m_pDelNet;
	KviPushButton           *m_pEditServer;
	KviPushButton           *m_pDelServer;
	KviPushButton           *m_pSort;
	KviPushButton           *m_pNewServer;
	KviPushButton           *m_pDelProxy;
	KviPushButton           *m_pEditProxy;
	KviFieldEditor          *m_pEditor;
	KviFieldEditor          *m_pProxyEditor;
	KviOptDlgServerField     m_curEditedServerField;
	KviOptDlgProxyField      m_curEditedProxyField;
	KviIrcServerListItem    *m_curEditedServerItem;
	KviIrcProxyListItem     *m_curEditedProxyItem;
};

#endif // _KVI_SERVERDIALOG_H_INCLUDED_
