/*
    KSocrat
    Version 3.1.2, 28 April 2003    
    (C) 2000-2003 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#include <kapp.h>
#include <kconfig.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <qtextcodec.h>
#include "ksocrat.h"
 
int main(int argc, char *argv[])
{
  KAboutData *aboutData = new KAboutData("ksocrat",
             "KSocrat","3.1.2",
             "KSocrat", KAboutData::License_GPL,
             I18N_NOOP("(C) 2000-2003 Zavolzhsky Alexandr"),
             I18N_NOOP("English/Russian and Russian/English dictionary"),
             "http://webua.net/zavolzhsky");
  aboutData->addAuthor(I18N_NOOP("Zavolzhsky Alexandr"),
             I18N_NOOP("Developer/Mantainer"),
             "zavolzhsky@mail.ru",
             "http://webua.net/zavolzhsky");
  aboutData->addCredit(I18N_NOOP("Dictionary bases are provided by Arsenal Company for KSocrat only."));
  aboutData->addCredit(I18N_NOOP("Dictionary bases (C) 1996 Arsenal Company, www.ars.ru, www.arssoft.com."));
  
  KCmdLineArgs::init(argc, argv, aboutData);
  
  KApplication a;
  a.setDefaultCodec(QTextCodec::codecForName("KOI8-R"));

  KConfig *config = kapp->config();
  config->setGroup("General");
  bool bHideOnStartUp = config->readBoolEntry("HideOnStartUp",false);
  
  KSocrat *ksocrat = new KSocrat();
  a.setMainWidget(ksocrat);
  ksocrat->setPlainCaption("KSocrat");

  if (!bHideOnStartUp) {
     ksocrat->show();  
  }

  return a.exec();
}
