
#include <qapplication.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include "kphone.h"

int main( int argc, char **argv )
{
	int listenport = 5060;
	QString port = "";
	QString user = "";
	bool looseRoute = false;
	bool strictRoute = false;

	QApplication a( argc, argv );

	// translation file for application strings
	QTranslator myapp( 0 );
	myapp.load( QString( "kphone_" ) + QTextCodec::locale(), PO_DIR );
	a.installTranslator( &myapp );
	
	for ( int i = 0; i < a.argc(); i++ ) {
		if( QString( a.argv()[i] ) == "-u" ) {
			if( i+1 < a.argc() ) {
				user = QString( a.argv()[++i] );
			}
		} else if( QString( a.argv()[i] ) == "-p" ) {
			if( i+1 < a.argc() ) {
				port = QString( a.argv()[++i] );
			}
			listenport = port.toInt();
		} else if( QString( a.argv()[i] ) == "-l" ) {
			looseRoute = true;
		} else if( QString( a.argv()[i] ) == "-s" ) {
			strictRoute = true;
		}
	}
	KPhone *phone = new KPhone( listenport, user, looseRoute, strictRoute );
	a.setMainWidget( phone );
	phone->show();
	return a.exec();
}
