#ifndef AUDIOCONTROL_H_INCLUDED
#define AUDIOCONTROL_H_INCLUDED
#include <qdialog.h>
#include <qbutton.h>
#include <qbuttongroup.h>

class QLineEdit;
class QRadioButton;
class CallAudio;

class AudioControl : public QDialog
{
	Q_OBJECT
public:
	AudioControl( QWidget *parent = 0, const char *name = 0 );
	~AudioControl( void );

protected slots:
	void ossButtonClicked( void );
	void alsaButtonClicked( void );
	void jackButtonClicked( void );
	void rwButtonClicked( void );
	void rowoButtonClicked( void );
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );

private:
	enum audiomode { oss, alsa, jack };
	enum rdwr { rw, rowo };
	enum Codecs { ulaw, gsm, ilbc };
	enum SizeOfPayload { size80, size160 };
	enum Ringingtone { ringingtoneYes, ringingtoneNo };
	QButtonGroup *bg1;
	QButtonGroup *bg2;
	QButtonGroup *bg3;
	QButtonGroup *bg4;
	CallAudio *a;
	QLineEdit *dspdev;
	QLineEdit *dspdev2;
	QButtonGroup *ringing;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
	QRadioButton *rwButton;
	QRadioButton *rowoButton;
	QRadioButton *ossButton;
	QRadioButton *alsaButton;
	QRadioButton *jackButton;
};

class VideoControl : public QDialog
{
	Q_OBJECT
public:
	VideoControl( QWidget *parent = 0, const char *name = 0 );
	~VideoControl( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );

private:
	enum Codecs { h261, h263 };
	QButtonGroup *bg1;
	QLineEdit *videoSW;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
};

#endif // AUDIOCONTROL_H_INCLUDED
