/*******************************************************************************
**                         timeinterval.cpp
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// My includes
#include "konservedebug.h"
#include "timeinterval.h"

////////////////////////////////////////////////////////////////////////////////
///////                 class timeinterval                               ///////
////////////////////////////////////////////////////////////////////////////////

TimeInterval::TimeInterval( unsigned int value, unsigned int measurement )
{
    TRACE();
    if ( TIME_SEC == measurement  )
    {
        mSecs        = value;
        mMeasurement = TIME_SEC;
    }
    else if  ( TIME_MIN == measurement  )
    {
        mSecs        = value * 60;
        mMeasurement = TIME_MIN;
    }
    else if  ( TIME_HOUR == measurement  )
    {
        mSecs        = value * 60 * 60;
        mMeasurement = TIME_HOUR;
    }
    else if  ( TIME_DAY == measurement )
    {
        mSecs        = value * 24 * 60 * 60;
        mMeasurement = TIME_DAY;
    }
    else
        Q_ASSERT( false );
}

TimeInterval::TimeInterval( unsigned int value, QString measurment )
{
    TRACE();
    if ( measurment == "sec" )
    {
        mSecs        = value;
        mMeasurement = TIME_SEC;
    }
    else if  ( measurment == "min" )
    {
        mSecs        = value * 60;
        mMeasurement = TIME_MIN;
    }
    else if  ( measurment == "hour" )
    {
        mSecs        = value * 60 * 60;
        mMeasurement = TIME_HOUR;
    }
    else if  ( measurment == "day" )
    {
        mSecs        = value * 24 * 60 * 60;
        mMeasurement = TIME_DAY;
    }
    else
        Q_ASSERT( false );
}

TimeInterval::TimeInterval( const TimeInterval& t )
    : mSecs( t.mSecs ),
      mMeasurement( t.mMeasurement )
{
    TRACE();
    // NOOP
}

TimeInterval::~TimeInterval()
{
    TRACE();
    // NOOP
}

unsigned int TimeInterval::value() const
{
    if ( TIME_SEC == mMeasurement )
        return mSecs;
    else if ( TIME_MIN == mMeasurement )
        return mSecs / 60;
    else if ( TIME_HOUR == mMeasurement )
        return mSecs / ( 60 * 60 );
    else if ( TIME_DAY == mMeasurement )
        return mSecs / ( 24 * 60 * 60 );
    else
        Q_ASSERT( false );
    return 0;
}

QString TimeInterval::measurement() const
{
    TRACE();
    if ( TIME_SEC == mMeasurement )
        return "sec";
    else if ( TIME_MIN == mMeasurement )
        return "min";
    else if ( TIME_HOUR == mMeasurement )
        return "hour";
    else if ( TIME_DAY == mMeasurement )
        return "day";
    else
        Q_ASSERT( false );

    return 0;
}

