/*******************************************************************************
**                            helper.cpp
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// Standard includes
// Do we have to check for existance of the following *.h - files?
#include <stdlib.h>
#include <unistd.h>
#include <grp.h>
#include <pwd.h>

// Qt includes
#include <qglobal.h>
#include <qstring.h>

// KDE includes
#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>

// My includes
#include "konservedebug.h"
#include "helper.h"

////////////////////////////////////////////////////////////////////////////////
///////                   class Helper                                   ///////
////////////////////////////////////////////////////////////////////////////////

QString Helper::homeDir()
{
    TRACE();
    QString home = ::getenv( "HOME" );

    if ( QString::null == home )
    {
        QString name = userName();

        if ( QString::null == name )
            return QString::null;

        struct passwd *passwd_struct = ::getpwnam( name.latin1() );
        home = passwd_struct->pw_dir;
    }
    if ( QString::null == home )
        KMessageBox::error( 0L,
                            i18n( "Couldn't figure out your home diretory" ),
                            i18n( "Error: no home" ) );

    return home;
}

bool Helper::isOK( KURL url, unsigned int mode )
{
    TRACE();
    Q_ASSERT( ( CHECK_NOTHING    & mode ) ||
              ( CHECK_MALFORMED  & mode ) ||
              ( CHECK_LOCAL_FILE & mode ) ||
              ( CHECK_EMPTY      & mode ) );

    if ( CHECK_NOTHING & mode )
        return true;

    if (( CHECK_MALFORMED & mode ) && ! url.isValid() )
    {
        KMessageBox::error(
            0L, i18n( "Url:\n %1 \n is malformed" ).arg( url.url() )
            );
        return false;
    }
    if (( CHECK_LOCAL_FILE & mode ) && (! url.isLocalFile() ))
    {
        KMessageBox::error(
            0L, i18n( "%1\n is not a local file" ).arg(  url.url() )
            );
        return false;
    }
    if (( CHECK_EMPTY & mode ) && url.isEmpty() )
    {
        KMessageBox::error( 0L, i18n( "No file or directory specified" ));
        return false;
    }
    return true;
}

QString Helper::userGroup()
{
    TRACE();
    QString name = userName();

    if ( QString::null == name )
        return QString::null;

    struct passwd *passwd_struct = ::getpwnam( name.latin1() );
    struct group  *group_struct  = ::getgrgid( passwd_struct->pw_gid );

    QString group_name = group_struct->gr_name;

    if ( QString::null == group_name )
        KMessageBox::error( 0L,
                            i18n( "Couldn't figure out your group" ),
                            i18n( "Error: no group" ) );

    return group_name;
}

QString Helper::userName()
{
    TRACE();
    QString name( ::getenv( "USER" ) );

    // hier ifdef
    if ( QString::null == name )
    {
        uid_t                    uid = ::getuid();
        struct passwd *passwd_struct = ::getpwuid( uid );

        name = passwd_struct->pw_name;
    }

    if ( QString::null == name )
    {
        KMessageBox::error( 0L,
                            i18n( "Error: couldn't figure out your username"
                                  "Please check your environment variable"
                                  "USER" ),
                            i18n( "Error: no username" ) );
    }

    return name;
}
