/***************************************************************************
                          recentmounts.h  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECENTMOUNTS_H
#define RECENTMOUNTS_H

#include <qstring.h>
#include <qptrlist.h>
#include <kaction.h>
#include <kconfig.h>
/**
  *@author Frank Schwanz
  */
#define MAXRECENTS 4

class MyShareItem;
class MyNetworkItem;

struct RecentMountItem
{
  QString share;
  QString workgroup;
  QString host;
  QString mountpath;
};

class RecentMounts:public KListAction
{
Q_OBJECT public:
  RecentMounts (const QString & text, int accel, const QObject * receiver,
		const char *slot, QObject * parent, const char *name = 0);
   ~RecentMounts ();
  void addRecentMount (MyShareItem * shareitem);
  const QStringList getItemList ();
  MyShareItem *getShareItem (MyNetworkItem * netitem, int id);
  const QString getMountPath (int id);
  void loadEntries (KConfig * config, QString groupname = QString::null);
  void saveEntries (KConfig * config, QString groupname = QString::null);
  const QStringList getRecentHosts ();
  const QStringList getRecentWorkgroups ();

private:

    QPtrList < RecentMountItem > reclist;

protected:
    RecentMountItem * getRecentItem (MyShareItem * shareitem);

};

#endif
