/* @(#) zone.c 1.40 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: DAEMON
\***************************************************************/

#define _KOALAMUD_ZONE_C "@(#) nitehawk@localhost.1ststep.net|src/zone/zone.c|20000827025251|53948 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "log.h"
#include "conf.h"
#include "memory.h"
#include "llist.h"
#include "uplinkprotocol.h"
#include "reboot.h"
#include "buffer.h"

/* Initialize state variables */
koalaerror daemoninitstate(void)
{
	koptions.daemontype = DAEMON_ZONE;
	return KESUCCESS;
};

/* Startup the daemon */
/* zonedaemon - Handle daemon functions for a zone server */
koalaerror rundaemon(void)
{
	pdescriptor desc = NULL;
	pdescriptor newdesc = NULL;
	koalaerror acceptreturn;
	listnodeptr desclist, tmplist;
	fd_set insockets, outsockets, errsockets;
	int descriptorcount;
	int numuplinks;
	int maxdescriptor;
	struct timeval sleeper;
	int selectreturn;
	unsigned long loopcount = 0;
	
	/* Startup networking */
	netstartup();

	/* Get pointer to master descriptor list */
	desclist = getdescriptorlist();

	/* check to see if this was a reboot */
	if (!(kstate.running == DSTATE_REBOOTING &&
				(reloaddescriptors() == KESUCCESS)))
	{
		/* If we are setting up a zone server, we should connect to a hub
		 * server if the uplink is defined, otherwise, start listening on the
		 * uplink port */
		if (confcreateuplink(desclist) == KENOUPLINK)
		{
			if (confcreatelisten(desclist) < 0)
			{
				logmsg(LOGCRIT, "Error starting network interface,"
						" shutting down");
				return KENONETWORK;
			}
		}
	}

	logmsg(LOGINFO, "Starting main zone daemon loop on node ID: %x",
			kstate.nodeid);
	while (kstate.running == DSTATE_RUNNING)
	{
		/* Zero out counters and socket sets */
		descriptorcount = 0;
		numuplinks = 0;
		maxdescriptor = 0;
		FD_ZERO(&insockets);
		FD_ZERO(&outsockets);
		FD_ZERO(&errsockets);

		/* Fill in fd_sets with open sockets */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

			/* Filter dummy sockets */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}

			/* Add Descriptor to select sets */
			if (desc->type != DESCRIPTOR_LISTEN)
			{
				numuplinks++;
				FD_SET(desc->socket, &errsockets);
				FD_SET(desc->socket, &outsockets);
			}
			FD_SET(desc->socket, &insockets);
			descriptorcount++;

			maxdescriptor = (maxdescriptor > desc->socket) ?
				maxdescriptor : desc->socket;
		}

		if (((loopcount++) % koptions.reportingperiod) == 0)
		{
			logmsg(LOGINFO, "%d descriptors, %d Listen, %d Uplink, Max FD=%d",
					descriptorcount, (descriptorcount - numuplinks),
					(numuplinks),
					maxdescriptor);
		}

		sleeper.tv_sec = 0;
		sleeper.tv_usec = koptions.ticklen;

		if ((selectreturn = select(maxdescriptor +1, &insockets,
			NULL, &errsockets, &sleeper)) < 0)
		{
			if (errno == EINTR)
			{
				logmsg(LOGINFO, "Waking up to process signal");
				continue;
			}
			logmsg(LOGCRIT, "Main zone daemon loop dead, bailing water");
			return KESELECTFAIL;
		}
		
		/* Process data from select */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

			/* Filter out invalid descriptors
			 * Since this is a zone daemon, player descriptors are considered
			 * invalid
			 */
			if (desc->type == DESCRIPTOR_DUMMY
					|| desc->type == DESCRIPTOR_NULL
					|| desc->type == DESCRIPTOR_PLAYER)
			{
				continue;
			}

			/* Close descriptors */
			if (desc->status == STATUS_CLOSE
					|| FD_ISSET(desc->socket, &errsockets))
			{
				tmplist = listprevnode(tmplist);
				listremovenode(desclist, desc);
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
				netclose(desc);
			}

			/* Handle sockets on input set */
			if (FD_ISSET(desc->socket, &insockets))
			{
				if (desc->type == DESCRIPTOR_LISTEN)
				{
					acceptreturn = netaccept(desc, &newdesc);
					if (acceptreturn == KENOMEM)
					{
						return KENOMEM;
					}
					if (acceptreturn == KENOACCEPT)
					{
						/* Probaly just no connections waiting
			 			 * 	shouldn't get this in normal operations */
						logmsg(LOGWARN, "No connections waiting");
						continue;
					}

					netwrite(newdesc, magic.daemonmagic,
								strlen(magic.daemonmagic));
					listaddnode(desclist, newdesc);
				}  // Is listen socket
				else
				{
					buffer_receive(desc);
				}
			} // Has input?

			/* Parse waiting input */
			if (desc->type == DESCRIPTOR_UNKNOWN &&
						desc->status < STATUS_NOMINAL)
			{
				/* This is an uplink, but we don't know what type yet
				 * - Handle protocol negotiation
				 */
				uplinknegotiatestage(desc);
			}
			/* We can't uplink to a client server */
			else if (desc->type >= DESCRIPTOR_HUBSRV &&
					desc->type <= DESCRIPTOR_ZONESRV &&
					desc->status == STATUS_NOMINAL)
			{
				/* If we have input on an uplink, pass it off to
				 * uplinkreceivemessage
				 */
				uplinkreceivemessage(desc);
			}
		}  // Select processor loop
	}  // Main zone daemon loop

	if (kstate.running == DSTATE_SHUTDOWN)
	{
		/* If we get here, we were told to shutdown the system, scan through the
		 * descriptor list and send a disconnect message to all uplinks */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			message_data msgdata;
			msgdata.data = NULL;

			desc = tmplist->data.desc;
			
			switch (desc->type)
			{
				case DESCRIPTOR_HUBSRV:
				case DESCRIPTOR_CLIENTSRV:
				case DESCRIPTOR_ZONESRV:
					/* Its an uplink - send a disconnect message */
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata, 0);
					break;

				default:
					continue;
			}
		}
	}

	return KESUCCESS;
}
