h62594
s 00001/00001/00102
d D 1.3 00/08/22 20:17:49 nitehawk 4 3
c Converting to new logmsg
cC
cHlocalhost.1ststep.net
cK15261
cZ-07:00
e
s 00025/00014/00078
d D 1.2 00/03/12 21:51:39 nitehawk 3 2
c Use new module definition structure
cC
cK14659
e
s 00092/00000/00000
d D 1.1 00/03/11 21:48:13 nitehawk 2 1
cC
cF1
cK65386
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/11 21:48:13 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/vm/dbkoala.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK00733
cPlib/vm/dbkoala.c
cR5fa9f6b06df45aa
cV3
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_DBKOALA_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"

/* This file implements the raw koala backend.  The API in this
 * file should *NOT* be called from outside of the VM library.
 */

/* Global variables */

/* Module state */
D 3
modstate_t dbkoalamodstate = MODSTATE_UNDEFINED;
E 3
I 3
module_t dbkoalamodule =
{
	"DB Koala",
	"%Z% %M% %I% %Z%",
	MODSTATE_UNDEFINED,
	dbkoalastartup,
	dbkoalalinkup,
	dbkoalashutdown
};
E 3

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* dbstartup - Startup db driver.  This should do things like prepare the
 * variables that connect us to an external SQL server.
 */
D 3
vmerr_t dbkoalastartup(void)
E 3
I 3
int dbkoalastartup(void)
E 3
{
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
D 3
	if (dbkoalamodstate != MODSTATE_UNDEFINED ||
			dbkoalamodstate != MODSTATE_STOPPED)
E 3
I 3
	if (!(dbkoalamodule.state == MODSTATE_UNDEFINED ||
			dbkoalamodule.state == MODSTATE_STOPPED))
E 3
		return VMBADSTATE;
	/* Reflect that we are starting up */
D 3
	dbkoalamodstate = MODSTATE_STARTUPINPROGRESS;
E 3
I 3
	dbkoalamodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Log a startup message */
D 4
	logmsg("Starting koala database driver");
E 4
I 4
	logmsg(LOGINFO, "Starting koala database driver");
E 4
E 3

	/* All done with startup */
D 3
	dbkoalamodstate = MODSTATE_STARTED;
E 3
I 3
	dbkoalamodule.state = MODSTATE_STARTED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - Create connection to external database or load disk indexes and
 * hashtables
 */
D 3
vmerr_t dbkoalalinkup(void)
E 3
I 3
int dbkoalalinkup(void)
E 3
{
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
D 3
	if (dbkoalamodstate != MODSTATE_STARTED)
E 3
I 3
	if (dbkoalamodule.state != MODSTATE_STARTED)
E 3
		return VMBADSTATE;
	/* show that we are doing linkup */
D 3
	dbkoalamodstate = MODSTATE_LINKUPINPROGRESS;
E 3
I 3
	dbkoalamodule.state = MODSTATE_LINKUPINPROGRESS;
E 3

	/* Linkup complete */
D 3
	dbkoalamodstate = MODSTATE_LINKED;
E 3
I 3
	dbkoalamodule.state = MODSTATE_LINKED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbshutdown - close off the database and clean up any external connections
 */
D 3
vmerr_t dbkoalashutdown(void)
E 3
I 3
int dbkoalashutdown(void)
E 3
{
	/* Can't shutdown unless we are currently 'linked' */
D 3
	if (dbkoalamodstate != MODSTATE_LINKED)
E 3
I 3
	if (dbkoalamodule.state != MODSTATE_LINKED)
E 3
		return VMBADSTATE;
	/* show that we are doing shutdown */
D 3
	dbkoalamodstate = MODSTATE_SHUTDOWNINPROGRESS;
E 3
I 3
	dbkoalamodule.state = MODSTATE_SHUTDOWNINPROGRESS;
E 3

	/* shutdown complete */
D 3
	dbkoalamodstate = MODSTATE_STOPPED;
E 3
I 3
	dbkoalamodule.state = MODSTATE_STOPPED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}
E 2
I 1
E 1
