/* @(#) reboot.c 1.12 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: REBOOT
*
*	This module implements live reboots
\***************************************************************/

#define _KOALAMUD_DAEMON_C "@(#) nitehawk@winghove.1ststep.net|lib/koala/reboot.c|20001105025142|33826 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "uplinkprotocol.h"
#include "reboot.h"
#include "llist.h"
#include "memory.h"
#include "network.h"

/* FIXME:  We need checking for null pointers during all allocations */

/* Write the current state to a file in prep for a live reboot */
koalaerror prepforreboot(void)
{
	listnodeptr desclist;
	pdescriptor desc;
	FILE *statefile;
	char rebootmsg[] = "Koala rebooting - one moment please\r\n";
	char filename[128];
	
	/* build filename */
	snprintf(filename, 128, "%s.%d", REBOOTSTATEFILE, getpid());

	/* open state file */
	if ((statefile = fopen(filename, "w")) == NULL)
	{
		logmsg(LOGCRIT, "Unable to open state file for reboot");

	}

	/* Store state for all sockets */
	desclist = getdescriptorlist();
	for(;desclist; desclist = listnextnode(desclist))
	{
		/* Get a pointer to the descriptor */
		desc = desclist->data.desc;

		/* Filter Dummy and Null sockets */
		if (desc->type == DESCRIPTOR_NULL || desc->type == DESCRIPTOR_DUMMY)
		{
			continue;
		}

		// turn close-on-exec off
		fcntl(desc->socket, F_SETFD, 0);

		/* Print the first line of descriptor info */
		fprintf(statefile, "%d %d %d %d\n",
				desc->socket, desc->type, desc->status, desc->nodeid);
		switch(desc->type)
		{
			case DESCRIPTOR_PLAYER:
				/* Save name and state */
				fprintf(statefile, "%d %d %d %s\n",
						desc->data.character->abbreviate,
						desc->data.character->state,
						strlen(desc->data.character->name),
						desc->data.character->name);
				netwrite(desc, rebootmsg, strlen(rebootmsg));
				break;

			case DESCRIPTOR_UNKNOWN:	// no extra data
			case DESCRIPTOR_LISTEN:		// no extra data
			case DESCRIPTOR_HUBSRV:		// no extra data
			case DESCRIPTOR_ZONESRV:	// no extra data
			case DESCRIPTOR_CLIENTSRV:	// no extra data
			default:
				break;
		}
	}

	/* close state file */
	fclose(statefile);

	/* Successfully prepped for reboot */
	return KESUCCESS;
}

/* Save socket state and reboot daemon */
koalaerror rebootdaemon(void)
{
	koalaerror kerr;

	kerr = prepforreboot();
	return kerr;
}

/* Rebuild descriptor list from state file */
koalaerror reloaddescriptors(void)
{
	pdescriptor desc;
	listnodeptr desclist;
	char linebuffer[1024];
	FILE *statefile;
	int namelen;
	char backmsg[] = "Finished rebooting - Koala back.\r\n"
		"Type version to see new version information\r\n";
	char filename[128];
	
	/* build filename */
	snprintf(filename, 128, "%s.%d", REBOOTSTATEFILE, getpid());

	/* Attempt to open state file */
	if ((statefile = fopen(filename, "r")) == NULL)
	{
		/* Set the state to running */
		kstate.running = DSTATE_RUNNING;
		logmsg(LOGCRIT, "Unable to open reboot state file,"
				" continuing standard bootup");
		return KEFOPEN;
	}

	/* get the descriptor list */
	desclist = getdescriptorlist();

	/* Loop through each line of the state file */
	while(fgets(linebuffer, 1024, statefile))
	{
		/* Allocate memory for the descriptor */
		desc = allocdescriptor();
		
		/* parse out string into descriptor variables */
		sscanf(linebuffer, "%d %d %d %d\n",
				&(desc->socket), (int *)&(desc->type), (int *)&(desc->status),
				(int *)&(desc->nodeid));
		switch(desc->type)
		{
			case DESCRIPTOR_PLAYER:
				/* Allocate memory for player information */
				desc->data.character = kmalloc(sizeof(character),
						ALLOC_DESCRIPTOR);

				/* Save name and state */
				fscanf(statefile, "%d %d %d ",
						(int *)&(desc->data.character->abbreviate),
						(int *)&(desc->data.character->state),
						&namelen);
				fgets(linebuffer, 1024, statefile);

				/* Alocate memory for name string */
				desc->data.character->name = kmalloc(namelen+2,
						ALLOC_DESCRIPTOR);
				bzero(desc->data.character->name, namelen+2);
				strncpy(desc->data.character->name, linebuffer, namelen);

				/* Write a message saying the server is back */
				netwrite(desc, backmsg, strlen(backmsg));
				break;

			case DESCRIPTOR_HUBSRV:		// no extra data
				/* Allocate memory for player information */
				desc->data.hubsrv = kmalloc(sizeof(hubsrvdata),
						ALLOC_DESCRIPTOR);
				desc->data.hubsrv->curmsg.messageid = 0;
				break;

			case DESCRIPTOR_ZONESRV:	// no extra data
				/* Allocate memory for player information */
				desc->data.zonesrv = kmalloc(sizeof(zonesrvdata),
						ALLOC_DESCRIPTOR);
				desc->data.zonesrv->curmsg.messageid = 0;
				break;
				
			case DESCRIPTOR_CLIENTSRV:	// no extra data
				/* Allocate memory for clientsrv information */
				desc->data.clientsrv = kmalloc(sizeof(clientsrvdata),
						ALLOC_DESCRIPTOR);
				desc->data.clientsrv->curmsg.messageid = 0;
				break;

			case DESCRIPTOR_UNKNOWN:	// no extra data
			case DESCRIPTOR_LISTEN:		// no extra data
			default:
				break;
		}

		/* Make sockets close again */
		fcntl(desc->socket, F_SETFD, 1);
		
		/* Add descriptor to linked list */
		listaddnode(desclist, desc);
	}

	/* Close and delete state file */
	fclose(statefile);
	unlink(filename);

	/* Set the state to running */
	kstate.running = DSTATE_RUNNING;

	/* We successfully loaded all the descriptors */
	return KESUCCESS;
}
