/* @(#) .del-dnode.h 1.8 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: db
\***************************************************************/

#ifndef _KOALAMUD_LIB_DNODE_H
#define _KOALAMUD_LIB_DNODE_H "@(#) nitehawk@winghove.1ststep.net|BitKeeper/deleted/.del-dnode.h|20000308020901|05444 @(#)"

/* We need fstypes.h for generic file system types */
#include "fstypes.h"

/*	These structures are all for the on disk database file.  */
/* Number of direct blocks */
#define KDADDR	12

/*  of indirect blocks */
#define KIADDR	3

/*	TAG_DNODE
 *		This is a database node.  All database entries are instances of this
 *		structure.
 *		Note: This structure is very similar to the inode structure of UFS.
 *		Major differences are:
 *			Shorter block lists since most objects are not going to be more
 *				then three or four blocks in size.
 *			'owner' and 'group' are dnode numbers
 */
typedef struct TAG_DNODE
{
	kdbfs_dnode_t	d_num;	/* 0: dnode number, keep for consistancy checking */
	kdbfs_dnode_t	d_uid;	/* 4: Pointer to object owner */
	kdbfs_dnode_t	d_gid;	/* 8: Pointer to object group */
	int32_t			d_ctime;	/* 12: Object creation time */
	int32_t			d_ctimesec;	/* 16: Object creation time */
	int32_t			d_atime;	/* 20: Last object access time */
	int32_t			d_atimesec;	/* 24: Last object access time */
	int32_t			d_mtime;	/* 28: Object modification time */
	int32_t			d_mtimesec;	/* 32: Object modification time */
	u_int16_t		d_links;	/* 36: Link counter */
	u_int64_t		d_size;		/* 38: Total object size */
	u_int32_t		d_blocks;	/* 46: Held Block count */
	u_int32_t		d_flags;	/* 50: Object flags. */
	u_int8_t		d_nodetype;		/* 54: Node type: see below */

	u_int8_t		d_spare[11];	/* 55: Reserved; currently unused */

	kdbfs_blockid_t	d_db[KDADDR];	/* 68: Direct disk blocks - 48 */
	kdbfs_blockid_t	d_ib[KIADDR];	/* 116: Indirect disk blocks - 12 */
} dnode;  /* Total size: 128 bytes */

/* Node type flags */
#define DNTYPE_FREE			0x0
#define DNTYPE_SYMLINK		0x1
#define DNTYPE_DIRECTORY	0x2
#define DNTYPE_OBJECT		0x3
#define DNTYPE_SHORTSYM		0x4

/* Short symlinks use the disk block fields to store the target path, this
 * saves allocation of a disk block for the target path
 */
#define MAXSSYMLEN ((KDADDR + KIADDR) * sizeof(kdbfs_blockid_t))

/* Special dnode numbers
 * 	Note: the Players tree does not *really* need special meaning.  It is
 * 	only specified to make new database creation easier.  /players/ and
 * 	/players/root/ will only exist on the root filesystem.  On other
 * 	filesystems, their respective dnodes can be used by other objects */
#define DNODE_ROOT		((kdbfs_blockid_t) 0)	// /
#define DNODE_PLAYERS	((kdbfs_blockid_t) 1)	// /players/
#define DNODE_ROOTOWN	((kdbfs_blockid_t) 2)	// /players/root

#endif
