#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "breakcalls.h"
#include "breakview.h"
#include "interface.h"
#include "serial.h"
#include "misc.h"
#include "view.h"
#include "callbacks.h"


int toggleoff=0;

void
breakpoint_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
 int worda, wordb;
 int count;
 int lildata;
 uchar *addressA;
 uchar *addressB;
 uchar dataA[8];
 uchar dataB[8];
 if (toggleoff) return;
 board_micro_ping();
 board_sendchar(BR_BP_GET|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
 if (4 != board_getb32(&worda)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 1\n");return;}
 if (4 != board_getb32(&wordb)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 2\n");return;}
// if(VERBOSE) g_print("worda:%x\nworda:%x\n",worda,wordb);
 if ((worda>>breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf])&1) {
    board_sendchar(BR_BP_READ|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
    board_sendchar(breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]);
    addressA=g_new(uchar,board_memory_ptr_width);
    addressB=g_new(uchar,board_memory_ptr_width);
    if (2 != board_getb16(&lildata)) {if(VERBOSE) g_print("breakcrash 3\n");return;}
    if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressA))  {if(VERBOSE) g_print("breakcrash 4\n");return;}
    if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressB))  {if(VERBOSE) g_print("breakcrash 5\n");return;}
    if (8 != board_getchararray(8, dataA))  {if(VERBOSE) g_print("breakcrash 6\n");return;}
    if (8 != board_getchararray(8, dataB))  {if(VERBOSE) g_print("breakcrash 7\n");return;}
    
    lildata= lildata ^ (GPOINTER_TO_INT(user_data)&0xFFFF);
    
    board_sendchar(BR_BP_WRITE|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
    board_sendchar(breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]);
    board_sendb16(lildata);
    board_sendchararray(board_memory_ptr_width, addressA);
    board_sendchararray(board_memory_ptr_width, addressB);
    board_sendchararray(8, dataA);
    board_sendchararray(8, dataB);
    g_free(addressA);
    g_free(addressB);
    }
 else {
    board_sendchar(BR_BP_WRITE|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
    board_sendchar(breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]);
    addressA = g_new(uchar,board_memory_ptr_width);
    board_sendb16(~(GPOINTER_TO_INT(user_data)&0xFFFF));
    for (count=0;count<board_memory_ptr_width; count++) addressA[count]= 0x00;
    board_sendchararray(board_memory_ptr_width, addressA);
    for (count=0;count<board_memory_ptr_width; count++) addressA[count]= 0xFF;
    board_sendchararray(board_memory_ptr_width, addressA);
    for (count=0;count<8; count++) dataA[count]= 0x00;
    board_sendchararray(8, dataA);
    for (count=0;count<8; count++) dataB[count]= 0x00;
    board_sendchararray(8, dataB); 
    g_free(addressA);
    }
 
    
 callback_global_refresh();
 breakpoint_refresh ((GPOINTER_TO_INT(user_data)>>0x10)&3);
 breakpoint_select( GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"clist")),breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf],0,NULL,user_data);
}

void
breakpoint_set                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
 int worda, wordb;
 if (toggleoff) return;
 board_micro_ping();
 board_sendchar(BR_BP_GET|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
 if (4 != board_getb32(&worda)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 8\n");return;}
 if (4 != board_getb32(&wordb)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 9\n");return;}
 
 if (GPOINTER_TO_INT(user_data)&0xFFFF)    {
        worda = 0;
        wordb = 1<<breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf];
        }
                
 else { worda = 1<<breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf];
        wordb = ~wordb & (1<<breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]);
        }
 
 board_sendchar(BR_BP_SET|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
 board_sendb32(worda);
 board_sendb32(wordb);
 breakpoint_select( GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"clist")),breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf],0,NULL,user_data);
 breakpoint_refresh ((GPOINTER_TO_INT(user_data)>>0x10)&3);
 callback_global_refresh();
}


void
breakpoint_select                      (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
 int worda, wordb;
 int lildata;
 uchar *addressA;
 uchar *addressB;
 uchar dataA[8];
 uchar dataB[8];
 char* text;
 toggleoff=1;
 breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]=row;
 board_micro_ping();
 board_sendchar(BR_BP_GET|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
 if (4 != board_getb32(&worda)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 10\n");return;}
 if (4 != board_getb32(&wordb)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 11\n");return;}
 if ((worda>>breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf])&1) {
    board_sendchar(BR_BP_READ|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
    board_sendchar(row);
    addressA=g_new(uchar,board_memory_ptr_width);
    addressB=g_new(uchar,board_memory_ptr_width);
    if (2 != board_getb16(&lildata)) {if(VERBOSE) g_print("breakcrash 12\n");return;}
    if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressA))  {if(VERBOSE) g_print("breakcrash 13\n");return;}
    if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressB))  {if(VERBOSE) g_print("breakcrash 14\n");return;}
    if (8 != board_getchararray(8, dataA))  {if(VERBOSE) g_print("breakcrash 15\n");return;}
    if (8 != board_getchararray(8, dataB))  {if(VERBOSE) g_print("breakcrash 16\n");return;}
    
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"buttonactivate")) ,(wordb>>breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf])&1);
    
    text = view_chararr2hexstrbe(board_memory_ptr_width, addressA);
    g_free(addressA);
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entryaddressa")),text);
    g_free(text);
    if (GPOINTER_TO_INT(user_data)>>0x14) {toggleoff=0; return;}
    
    gtk_option_menu_set_history (GTK_OPTION_MENU(gtk_object_get_data(GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"optionaddress")), (lildata>>2)&1);
    
    text = view_chararr2hexstrbe(board_memory_ptr_width, addressB);
    g_free(addressB);
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entryaddressb")),text);
    g_free(text);
    
    text = view_chararr2hexstrbe(8, dataA);
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entrydataa")),text);
    g_free(text);
    
    gtk_option_menu_set_history (GTK_OPTION_MENU(gtk_object_get_data(GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"optiondata")), lildata&1);

    text = view_chararr2hexstrbe(8, dataB);
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entrydatab")),text);
    g_free(text);
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit8")) ,(lildata>>8)&1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit16")),(lildata>>9)&1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit32")),(lildata>>10)&1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit64")),(lildata>>11)&1);    
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkkernel")),(lildata>>6)&1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkuser")),(lildata>>7)&1);    
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkwrite")),(lildata>>4)&1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkread")),(lildata>>5)&1);    
    
    }
 else   {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"buttonactivate")) ,(wordb>>breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf])&1);
    text = g_strnfill (board_memory_ptr_width<<1,'0');
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entryaddressa")),text);
    g_free(text);
    if (GPOINTER_TO_INT(user_data)>>0x14) {toggleoff=0; return;}
    
    gtk_option_menu_set_history (GTK_OPTION_MENU(gtk_object_get_data(GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"optionaddress")), 1);
    
    text = g_strnfill (board_memory_ptr_width<<1,'F');
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entryaddressb")),text);
    g_free(text);
    
    text = g_strnfill (16,'0');
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entrydataa")),text);
    g_free(text);
    
    gtk_option_menu_set_history (GTK_OPTION_MENU(gtk_object_get_data(GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"optiondata")), 1);

    text = g_strnfill (16,'0');
    gtk_entry_set_text(GTK_ENTRY( gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"entrydatab")),text);
    g_free(text);
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit8")) ,1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit16")),1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit32")),1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"bit64")),1);    
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkkernel")),1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkuser")),  1);    
    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkwrite")),1);    
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gtk_object_get_data (GTK_OBJECT(view_breakwindow[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]),"checkread")), 1);    

    
    
    }
  toggleoff=0;

}

void breakpoint_refresh (int brwc)
{
 int worda, wordb;
 int count;
 int lildata,column;
 uchar *addressA;
 uchar *addressB;
 uchar dataA[8];
 uchar dataB[8];
 char* text;
 GtkCList *clist = GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][brwc]),"clist"));
 gtk_clist_freeze (clist);
 board_sendchar(BR_BP_GET| (brwc<<2));
 if (4 != board_getb32(&worda)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 17\n");return;}
 if (4 != board_getb32(&wordb)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 18\n");return;}
 for (count=0; count<32; count++){
    if ((worda>>count)&1) {
        board_micro_ping();
        board_sendchar(BR_BP_READ|(brwc<<2));
        board_sendchar(count);
        addressA=g_new(uchar,board_memory_ptr_width);
        addressB=g_new(uchar,board_memory_ptr_width);
        if (2 != board_getb16(&lildata)) {if(VERBOSE) g_print("breakcrash 19\n");return;}
        if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressA))  {if(VERBOSE) g_print("breakcrash 20\n");return;}
        if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressB))  {if(VERBOSE) g_print("breakcrash 21\n");return;}
        if (8 != board_getchararray(8, dataA))  {if(VERBOSE) g_print("breakcrash 22\n");return;}
        if (8 != board_getchararray(8, dataB))  {if(VERBOSE) g_print("breakcrash 23\n");return;}
        
        clist = GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[1][brwc]),"clist"));
        if ((wordb>>count)&1) gtk_clist_set_pixmap(clist,count,0, view_tick_pixmap, view_tick_bitmap);
        else gtk_clist_set_text(clist,count,0,"");
        
        if ((wordb>>count)&1) gtk_clist_set_foreground (clist,count ,&view_blackcolour);
        else gtk_clist_set_foreground (clist,count, &view_greycolour);
        
        text = view_chararr2hexstrbe(board_memory_ptr_width, addressA);
        gtk_clist_set_text(clist,count,1,text);
        g_free(text);
        
        
        
        
        
        clist = GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][brwc]),"clist"));
        if ((wordb>>count)&1) gtk_clist_set_pixmap(clist,count,0, view_tick_pixmap, view_tick_bitmap);
        else gtk_clist_set_text(clist,count,0,"");
        
        if ((wordb>>count)&1) gtk_clist_set_foreground (clist,count ,&view_blackcolour);
        else gtk_clist_set_foreground (clist,count, &view_greycolour);;
        
        text = view_chararr2hexstrbe(board_memory_ptr_width, addressA);
        gtk_clist_set_text(clist,count,1,text);
        g_free(text);
        
        if (lildata & 0x4)  text = "Mask";
        else                text = "<= X <=";
        gtk_clist_set_text(clist,count,2,text);
        
        
        text = view_chararr2hexstrbe(board_memory_ptr_width, addressB);
        gtk_clist_set_text(clist,count,3,text);
        g_free(text);
        
         text = view_chararr2hexstrbe(8, dataA);
        gtk_clist_set_text(clist,count,4,text);
        g_free(text);

        if (lildata & 0x1)  text = "Mask";
        else                text = "<= X <=";
        gtk_clist_set_text(clist,count,5,text);
        
        
        text = view_chararr2hexstrbe(8, dataB);
        gtk_clist_set_text(clist,count,6,text);
        g_free(text);
            {
            char *liltext[9]={"","","","","","","","",""};
            liltext[8]=NULL;
            
            if ((lildata & 0xF00) &&
                (lildata & 0xC0)  &&
                (lildata & 0x30)) {
                if (0xF00 != (lildata & 0xF00)){
                    if (lildata & 0x100)    liltext[0] = "8b ";
                    if (lildata & 0x200)    liltext[1] = "16b ";
                    if (lildata & 0x400)    liltext[2] = "32b ";
                    if (lildata & 0x800)    liltext[3] = "64b ";
                    }
                if (0xC0 != (lildata & 0xC0)){
                    if (lildata & 0x80)     liltext[4] = "user ";
                    if (lildata & 0x40)     liltext[5] = "kernel ";
                    }
                if (0x30 != (lildata & 0x30)){
                    if (lildata & 0x20)     liltext[6] = "read ";
                    if (lildata & 0x10)     liltext[7] = "write ";
                    }
                }
            else liltext[0] = "DISABLED";
            
            text = g_strjoinv("",liltext);
            gtk_clist_set_text(clist,count,7,text);
            g_free(text);
            }
        }
    else {
        clist = GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[1][brwc]),"clist"));
        gtk_clist_set_text(clist,count,0,"Deleted");
        if (!(wordb>>count)&1) for(column=31;column>=count;column--) gtk_clist_remove (clist,column);
        gtk_clist_set_text(clist,count,1,"");
                
        clist = GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][brwc]),"clist"));
        gtk_clist_set_text(clist,count,0,"Deleted");
        if (!(wordb>>count)&1) for(column=31;column>=count;column--) gtk_clist_remove (clist,column);
        for (column=1;column<8;column++)    gtk_clist_set_text(clist,count,column,"");
        }
            
    }
 
 gtk_clist_thaw (clist);
}

void
breakpoint_enterval                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
 uchar *addressA;
 uchar *addressB;
 uchar dataA[8];
 uchar dataB[8];
 unsigned int  lildata;
 int worda, wordb, count;
 char* text = gtk_editable_get_chars(editable,0,-1);
 uchar* hexval = g_new(uchar,MAX(board_memory_ptr_width,8));
 
 board_sendchar(BR_BP_GET|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
 if (4 != board_getb32(&worda)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 24\n");return;}
 if (4 != board_getb32(&wordb)) {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 25\n");return;}

 if (!view_hexstr2chararr(MAX(board_memory_ptr_width,8), text, hexval))  /* get value from entry*/
                {board_mini_ping(0);if(VERBOSE) g_print("breakcrash 26\n");g_free(text); g_free(hexval);return;}
                
    
 addressA = g_new(uchar,board_memory_ptr_width);
 addressB = g_new(uchar,board_memory_ptr_width);
 if ((worda>>breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf])&1) {
    
    board_sendchar(BR_BP_READ|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
    board_sendchar(breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]);
    if (2 != board_getb16(&lildata)) {if(VERBOSE) g_print("breakcrash 27\n");return;}
    if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressA))  {if(VERBOSE) g_print("breakcrash 27\n");return;}
    if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width, addressB))  {if(VERBOSE) g_print("breakcrash 28\n");return;}
    if (8 != board_getchararray(8, dataA))  {if(VERBOSE) g_print("breakcrash 30\n");return;}
    if (8 != board_getchararray(8, dataB))  {if(VERBOSE) g_print("breakcrash 31\n");return;}
    }
 else {
    lildata=0xffffffff;
    for (count=0;count<board_memory_ptr_width; count++) addressA[count]= 0x00;
    for (count=0;count<board_memory_ptr_width; count++) addressB[count]= 0xFF;
    for (count=0;count<8; count++) dataA[count]= 0x00;
    for (count=0;count<8; count++) dataB[count]= 0x00;
    }
    
    board_sendchar(BR_BP_WRITE|((GPOINTER_TO_INT(user_data)>>0x10)&3)<<2);
    board_sendchar(breakpoint_line[GPOINTER_TO_INT(user_data)>>0x14][(GPOINTER_TO_INT(user_data)>>0x10)&0xf]);
    board_sendb16(lildata);
    if (0 == (GPOINTER_TO_INT(user_data)&0xFFFF))    board_sendchararray(board_memory_ptr_width, hexval);
    else                                             board_sendchararray(board_memory_ptr_width, addressA);
    if (1 == (GPOINTER_TO_INT(user_data)&0xFFFF))    board_sendchararray(board_memory_ptr_width, hexval);
    else                                             board_sendchararray(board_memory_ptr_width, addressB);
    if (2 == (GPOINTER_TO_INT(user_data)&0xFFFF))    board_sendchararray(8, hexval);
    else                                             board_sendchararray(8, dataA);
    if (3 == (GPOINTER_TO_INT(user_data)&0xFFFF))    board_sendchararray(8, hexval);
    else                                             board_sendchararray(8, dataB);
    
    g_free(addressA);
    g_free(addressB);
    g_free(text); 
    g_free(hexval);
    breakpoint_refresh ((GPOINTER_TO_INT(user_data)>>0x10)&3);
    callback_global_refresh();
}



