#ifndef __XDevice_CLASS__
#define __XDevice_CLASS__

#include <klogicList.h>
#include <device.h>
#include <qpixmap.h>
#include <xobject.h>
#include <device.h>
#include <deviceInterface.h>
#include <imageCache.h>

class XWire;
class Circuit;

/********************************************
* a device on the screen                    *
*********************************************/
class XDevice: public XObject, public DeviceInterface
{
public:
	static int instance;

	XDevice(int iFunction, const QPoint& oPos, int iSize = -1);
	virtual ~XDevice();

	// positioning methods
	bool moveTo(const QPoint&);			// absolute move
	void moveBy(const QPoint&);			// relative move

	// drawing methods
	void erase(QPainter *);				// erase device image
	virtual void setImage();			// internal redraw of the device pixmap
	void drawImage(QPainter *);			// draw device as lines and text to a printer device
	virtual bool setColor() { return false; }	// set image by actual state of input/output  (LED, 7S)
	void drawImage(QPaintDevice *, QPainter *);	// the usual method to draw devices!

	// graph methods
	virtual bool drawGraph();
	bool graphEnabled();
	void enableGraph(bool);
	int invertGraph(int, int);

	// some graphical device properties
	int size();
	virtual bool setSize(int);
	virtual int neededSize();
	virtual bool sizeChangeable() const { return true; }

	bool isInverted();
	void setInverted(bool);
	int maxI();
	int currI();
	void setMaxI(int);
	int maxO();
	int currO();
	void setMaxO(int);
	virtual void setName(const QString&);
	virtual void displayName(bool);
	bool nameDisplayed();
	void setTristate(bool);
	int getTristateControlPos();
	void setTristateControlPos(int);
	void setTristateInputImport();
	virtual void setUndefinedValue(int);
	virtual void setWidth(int) {}
	virtual int width() { return Global::Device::DEFAULT_WIDTH; }
	virtual void setColor(int) {}
	virtual int getColor() { return 0; }

	// special cases: properties dialog methods
	// return pointers to input/output lists
	// called by PropDev
	KlogicList<XWire> *getIRef();
	KlogicList<XWire> *getORef();

	// check and set/reset connections
	int checkConnection(XWire *, bool bInvert = false);

	// called by wire: add/remove connections
	int inputIsInvertedAt(QPoint);
	void addInputWire(XWire *);
	void removeInputWire(XWire *);
	int outputIsInvertedAt(QPoint);
	void addOutputWire(XWire *);
	void removeOutputWire(XWire *);

	// remove garbage from wires
	void garbageCollection();

	// add/remove named inputs/outputs (overloaded from class Device)
	virtual int addInputName(const QString&, int pos = -1, int iInputID = 0);
	virtual int changeInputName(int, const QString&);
	virtual void removeInputName(int);
	virtual int addOutputName(const QString&, int pos = -1, int iOutputID = 0);
	virtual int changeOutputName(int, const QString&);
	virtual void removeOutputName(int);

	// circuit management
	virtual Circuit * devIsCircuit() { return 0; };	// this is not a Circuit
	virtual bool addChild(XDevice *, bool) { return true; };
	virtual void setParent(XDevice *) {};

	virtual void init();

	// image caches
	static BasicImageCache m_oBasicImageCache;
	static ImageCache m_oImageCache;

protected:
	virtual Image * createImage(const ImageKey&);
	virtual void setImageKey() { m_oImageKey.setSymbolSet(Global::Device::getSymbolSet()); }
	virtual void printImage(QPainter *, const QRect &);

	// connected wires
	KlogicList<XWire> m_oIncomingWires;
	KlogicList<XWire> m_oOutgoingWires;

	int deviceMaxInput;
	int deviceMaxOutput;
	bool deviceOutputInverted;

	// text device, optionally displayed above this
	XDevice *m_poTextDev;

	ImageKey m_oImageKey;				// image cache key

private:
	static const QString INPUT_TRISTATE_CONTROL;

	void updateWires();

	int checkInput(XWire *, bool, bool);
	int connectInput(XWire *, QPoint, bool, int iInputID = 0);
	int checkOutput(XWire *, bool, bool);
	int connectOutput(XWire *, QPoint, bool, int iOutputID = 0);

	void prepareTristateInputImport();

	int m_iSize;

	// tristate handling
	int m_iTristateInputMoved;
	int m_iTristateImportPos;

	// device displayed in graph
	bool m_bGraphEnabled;
public:
	// old device import
	bool string2device(QString, int, int);

};

#endif

