/***********************************************************************
**
**   gliders.h
**
**   This file is part of KFLog2.
**
************************************************************************
**
**   Copyright (c):  2003 Christof Bodner
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: gliders.h,v 1.2 2003/03/06 17:58:09 christof Exp $
**
***********************************************************************/

#ifndef GLIDERS_H
#define GLIDERS_H

struct olc_glider
{
  char value[30];
  char name[30];
  int index;
};

struct olc_glider gliderList[]=
{
    {"AFH22","AFH 22",96},
    {"AFH24","AFH 24",106},
    {"AK5","AK 5",104},
    {"ALPIN","Alpin",84},
    {"ALPINT","Alpin T",84},
    {"AS22-2","AS 22-2",124},
    {"ASH25","ASH 25",124},
    {"ASH2526M","ASH 25/>26m",126},
    {"ASH25E","ASH 25E",124},
    {"ASH25E26M","ASH 25E/>26m",126},
    {"ASH25M","ASH 25M",124},
    {"ASH25M26M","ASH 25M/>26m",126},
    {"ASH26","ASH 26",120},
    {"ASK13","ASK 13",78},
    {"ASK14","ASK 14",82},
    {"ASK18","ASK 18",88},
    {"ASK21","ASK 21",92},
    {"ASK23","ASK 23",92},
    {"ASTIRCS","Astir CS",96},
    {"ASTIRCS77","Astir CS 77",96},
    {"ASTIRCSJEANS","Astir CS Jeans",94},
    {"ASTIRCSTOP","Astir CS Top",96},
    {"ASW12","ASW 12",110},
    {"ASW15","ASW 15",98},
    {"ASW17","ASW 17",116},
    {"ASW19","ASW 19",100},
    {"ASW19CLUB","ASW 19 Club",98},
    {"ASW20","ASW 20",110},
    {"ASW20166M","ASW 20 16,6m",112},
    {"ASW20TOP","ASW 20 Top",108},
    {"ASW20TOP166M","ASW 20 Top 16,6m",110},
    {"ASW22B","ASW 22 B",126},
    {"ASW2222M","ASW 22/22m",122},
    {"ASW2224M","ASW 22/24m",124},
    {"ASW22BL","ASW 22BL",128},
    {"ASW22BLE","ASW 22BLE",128},
    {"ASW22E24M","ASW 22E/24m",124},
    {"ASW24","ASW 24",108},
    {"ASW24E","ASW 24E",108},
    {"ASW27","ASW 27",114},
    {"ASW28","ASW 28",108},
    {"AV36","AV 36",74},
    {"B12","B 12",106},
    {"B13","B 13",110},
    {"BERGFALKEII","Bergfalke II",76},
    {"BERGFALKEIII","Bergfalke III",78},
    {"BERGFALKEIV","Bergfalke IV",84},
    {"BOCIAN","Bocian",78},
    {"BS1","BS 1",108},
    {"CALIFA21","Calif A 21",106},
    {"CARAT","Carat",92},
    {"CIRRUS1834M","Cirrus 18,34m",104},
    {"CIRRUSB","Cirrus B",100},
    {"CLUBLIBELLE","Club Libelle",96},
    {"COBRA15","Cobra 15",98},
    {"COBRA17M","Cobra 17m",102},
    {"CONDORIV","Condor IV",80},
    {"D36","D 36",108},
    {"D37","D 37",100},
    {"D38","D 38",98},
    {"D40","D 40",108},
    {"DG100","DG 100",100},
    {"DG100CLUB","DG 100 Club",98},
    {"DG100018M","DG 1000/18m",108},
    {"DG100020M","DG 1000/20m",110},
    {"DG200","DG 200",108},
    {"DG20017","DG 200/17",110},
    {"DG300","DG 300",106},
    {"DG300OHNEEZ","DG 300 w/o RG",104},
    {"DG303","DG 303",108},
    {"DG400","DG 400",108},
    {"DG40017","DG 400/17",110},
    {"DG50020M","DG 500 20m",108},
    {"DG50022M","DG 500 22m",110},
    {"DG500TRAINERMITEZ","DG 500 Trainer w. RG",100},
    {"DG500TRAINEROHNEEZ","DG 500 Trainer w/o RG",98},
    {"DG500M20M","DG 500M 20m",108},
    {"DG500M22M","DG 500M 22m",110},
    {"DG50520M","DG 505 20m",108},
    {"DG50522M","DG 505 22m",110},
    {"DG5056ORION","DG 505 6 Orion",104},
    {"DG505TRAINERMITEZ","DG 505 Trainer w. RG",100},
    {"DG505TRAINEROHNEEZ","DG 505 Trainer w/o RG",98},
    {"DG505M20M","DG 505M 20m",108},
    {"DG505M22M","DG 505M 22m",110},
    {"DG505MORION20M","DG 505M Orion 20m",104},
    {"DG600","DG 600",110},
    {"DG60017M","DG 600/17m",116},
    {"DG60018M","DG 600/18m",118},
    {"DG600M","DG 600M",110},
    {"DG600M17M","DG 600M/17m",116},
    {"DG600M18M","DG 600M/18m",118},
    {"DG80018M","DG 800/18m",120},
    {"DG800S","DG 800S",114},
    {"DG800S18M","DG 800S/18m",120},
    {"DIAMANT165M","Diamant 16,5m",104},
    {"DIAMANT18M","Diamant 18m",108},
    {"DIMONA","Dimona",76},
    {"DISCUS","Discus",108},
    {"DISCUS2","Discus 2",108},
    {"DISCUS2T","Discus 2T",108},
    {"DISCUSBM","Discus bM",108},
    {"DISCUSBT","Discus bT",108},
    {"DUODISCUS","Duo Discus",110},
    {"DUODISCUST","Duo Discus T",110},
    {"ELFEOHNEEZ","Elfe w/o RG",94},
    {"ELFE17M","Elfe 17m",100},
    {"ELFES3","Elfe S3",96},
    {"ELFES4","Elfe S4",96},
    {"ETA","eta",132},
    {"FALKON","Falkon",106},
    {"FK-3","FK-3",106},
    {"FOKA","Foka",88},
    {"FS25","fs 25",94},
    {"FS29","fs 29",116},
    {"FS31","fs 31",98},
    {"FS32","fs 32",110},
    {"FS33","fs 33",108},
    {"G1022ASTIR","G 102 2 Astir",92},
    {"G103TWINII","G 103 Twin II",92},
    {"G103TWINIII","G 103 Twin III",96},
    {"G103TWINIIISL","G 103 Twin III SL",96},
    {"GEIER","Geier",88},
    {"GENESIS","Genesis",108},
    {"GLASFLUGEL304C","Glasflugel 304C",106},
    {"GLASFLUGEL304CZ174M","Glasflugel 304CZ/17,4m",112},
    {"GLASFLGEL304","Glasflgel 304",110},
    {"GLASFLGEL30417","Glasflgel 304/17",112},
    {"GLASFLGEL604","Glasflgel 604",118},
    {"GLASFLGEL60424M","Glasflgel 604/24m",120},
    {"GREIFII","Greif II",86},
    {"GRUNAUBABY","Grunau Baby",54},
    {"H101SALTO","H 101 Salto",88},
    {"H30","H 30",84},
    {"H301","H 301",102},
    {"HORNET","Hornet",100},
    {"IS28B2","IS 28 B2",84},
    {"IS29D","IS 29 D",96},
    {"JANTAR19M","Jantar 19m",114},
    {"JANTAR2","Jantar 2",116},
    {"JANTAR2B","Jantar 2b",116},
    {"JANUS182M","Janus 18,2m",104},
    {"JANUSCMITEZ","Janus C w. RG",108},
    {"JANUSCOHNEEZ","Janus C w/o RG",106},
    {"JANUSCMMITEZ","Janus CM w. RG",108},
    {"JANUSCMOHNEEZ","Janus CM w/o RG",106},
    {"JANUSCTMITEZ","Janus CT w. RG",108},
    {"JANUSCTOHNEEZ","Janus CT w/o RG",106},
    {"KA1","Ka 1",54},
    {"KA10","Ka 10",86},
    {"KA2","Ka 2",74},
    {"KA2B","Ka 2 B",76},
    {"KA3","Ka 3",54},
    {"KA6","Ka 6",84},
    {"KA6E","Ka 6 E",86},
    {"KA7","Ka 7",76},
    {"KA8","Ka 8",78},
    {"KESTREL17M","Kestrel 17m",112},
    {"KESTREL19M","Kestrel 19m",114},
    {"KIWI","Kiwi",96},
    {"KIWI","Kiwi",92},
    {"KRANICHII","Kranich II",74},
    {"KRANICHIII","Kranich III",80},
    {"L13BLANIK","L 13 Blanik",76},
    {"L23SUPERBLANIK","L 23 Super Blanik",76},
    {"L23SUPERBLANIK182M","L 23 Super Blanik 18,2m",78},
    {"L-33SOLO","L-33 Solo",86},
    {"L-SPATZ","L-Spatz",78},
    {"LAK12","LAK 12",116},
    {"LAK1715M","LAK 17/15m",114},
    {"LAK1718M","LAK 17/18m",120},
    {"LAK1915M","LAK 19/15m",108},
    {"LAK1918M","LAK 19/18m",114},
    {"LCFII","LCF II",80},
    {"LS1F","LS 1 f",100},
    {"LS1-0","LS 1-0",98},
    {"LS1-0OHNEEZ","LS 1-0 w/o RG",96},
    {"LS1-C","LS 1-c",98},
    {"LS1-D","LS 1-d",98},
    {"LS2","LS 2",102},
    {"LS3","LS 3",108},
    {"LS3STD","LS 3 Std.",106},
    {"LS317","LS 3/17",110},
    {"LS4","LS 4",106},
    {"LS5","LS 5",122},
    {"LS6","LS 6",112},
    {"LS6175M","LS 6/17,5m",118},
    {"LS618M","LS 6/18m",118},
    {"LS7","LS 7",106},
    {"LS8","LS 8",108},
    {"LS818M","LS 8/18m",114},
    {"LS8T18M","LS 8T/18m",114},
    {"LS9","LS 9",120},
    {"LUNAKLF107","Lunak LF 107",78},
    {"M-25","M-25",86},
    {"M-28","M-28",87},
    {"M-35","M-35",92},
    {"MG23","MG 23",76},
    {"MININIMBUS","Mini Nimbus",108},
    {"MINIMOA","Minimoa",76},
    {"MISTRALC","Mistral C",96},
    {"MOSQUITO","Mosquito",108},
    {"MOSQUITO17M","Mosquito 17m",110},
    {"MUCHA","Mucha",80},
    {"MUCHASTANDARDSZD22","Mucha Standard SZD 22",82},
    {"M22B","M 22b",98},
    {"M26","M 26",104},
    {"M27","M 27",110},
    {"NIMBUS2B","Nimbus 2 b",116},
    {"NIMBUS2C","Nimbus 2 c",116},
    {"NIMBUS3229M","Nimbus 3/22,9m",122},
    {"NIMBUS3245M","Nimbus 3/24,5m",124},
    {"NIMBUS3255M","Nimbus 3/25,5m",126},
    {"NIMBUS3D","Nimbus 3D",124},
    {"NIMBUS3DM","Nimbus 3DM",124},
    {"NIMBUS3DT","Nimbus 3DT",124},
    {"NIMBUS3T255M","Nimbus 3T/25,5m",126},
    {"NIMBUS4","Nimbus 4",128},
    {"NIMBUS4D","Nimbus 4D",126},
    {"NIMBUS4DM","Nimbus 4DM",126},
    {"NIMBUS4DT","Nimbus 4DT",126},
    {"NIMBUS4M","Nimbus 4M",128},
    {"NIMBUS4T","Nimbus 4T",128},
    {"PANJOV12","Panjo V1/2",98},
    {"PEGASE","Pegase",104},
    {"PHBUSA","Phbus A",94},
    {"PHBUSB","Phbus B",96},
    {"PHBUSB3","Phbus B 3",100},
    {"PHBUSC","Phbus C",100},
    {"PHNIX","Phnix",92},
    {"PIK16VASAMA","PIK 16 Vasama",88},
    {"PIK20B","PIK 20 B",102},
    {"PIK20D","PIK 20 D",106},
    {"PIK20E","PIK 20 E",106},
    {"PILATUSB4MITEZ","Pilatus B4 w. RG",88},
    {"PILATUSB4OHNEEZ","Pilatus B4 w/o RG",86},
    {"PW5","PW 5",86},
    {"RHNBUSSARD","Rhnbussard",60},
    {"RHNLERCHE","Rhnlerche",54},
    {"SAGITTA","Sagitta",82},
    {"SALTO155M","Salto 15,5m",96},
    {"SB10","SB 10",120},
    {"SB11","SB 11",110},
    {"SB12","SB 12",106},
    {"SB13","SB 13",108},
    {"SB14","SB 14",120},
    {"SB5A","SB 5 a",86},
    {"SB5B","SB 5 b",86},
    {"SB5C","SB 5 c",86},
    {"SB5E","SB 5 E",88},
    {"SB7","SB 7",100},
    {"SB8","SB 8",106},
    {"SF26","SF 26",84},
    {"SF27A","SF 27 A",88},
    {"SF27B","SF 27 B",90},
    {"SF30","SF 30",88},
    {"SF34MITEZ","SF 34 w. RG",88},
    {"SF34OHNEEZ","SF 34 w/o RG",86},
    {"SHK","SHK",96},
    {"SIE3","SIE 3",86},
    {"SOLOL33","Solo L 33",86},
    {"SPATZ13M","Spatz 13m",74},
    {"SPECHT","Specht",54},
    {"SPEEDASTIRII","Speed Astir II",106},
    {"STDASTIR","Std. Astir",100},
    {"STDAUSTRIA","Std. Austria",86},
    {"STDAUSTRIASH","Std. Austria SH",88},
    {"STDAUSTRIASH1","Std. Austria SH1",90},
    {"STDCIRRUS","Std. Cirrus",98},
    {"STDCIRRUS16M","Std. Cirrus 16m",100},
    {"STDCIRRUSTOP","Std. Cirrus Top",98},
    {"STDJANTAR","Std. Jantar",100},
    {"STDLIBELLE","Std. Libelle",98},
    {"STDLIBELLE17M","Std. Libelle 17m",100},
    {"STEMMES10","Stemme S 10",110},
    {"SZD30PIRAT","SZD 30 Pirat",86},
    {"SZD50PUCHACZ","SZD 50 Puchacz",84},
    {"SZD51JUNIOR","SZD 51 Junior",90},
    {"SZD55","SZD 55",108},
    {"SZD56DIANA","SZD 56 Diana",114},
    {"SZD59","SZD 59",100},
    {"SZD-45A","SZD-45 A",76},
    {"TWINASTIRMITEZ","Twin Astir w. RG",94},
    {"TWINASTIRTRAINEROHNEEZ","Twin Astir Trainer w/o RG",92},
    {"TWINIII20M","Twin III/20m",98},
    {"VENTUS1","Ventus 1",112},
    {"VENTUS166M","Ventus 16,6m",114},
    {"VENTUS176M","Ventus 17,6m",116},
    {"VENTUS2","Ventus 2",114},
    {"VENTUS2C18M","Ventus 2c/18m",120},
    {"VENTUS2CM18M","Ventus 2cM/18m",120},
    {"VENTUS2CT18M","Ventus 2cT/18m",120},
    {"VENTUSBT176M","Ventus bT 17,6m",116},
    {"VENTUSCM176M","Ventus cM 17,6m",116},
    {"VENTUSCT176M","Ventus cT 17,6m",116},
    {"VSB-62VEGA","VSB-62 Vega",92},
    {"VSM-40","VSM-40",87},
    {"VSO-10","VSO-10",96},
    {"VSO-10C","VSO-10 C",94},
    {"VT-116ORLIK2","VT-116 Orlik 2",86},
    {"VT-125SOHAJ","VT-125 Sohaj",73},
    {"VT-16ORLIK","VT-16 Orlik",86},
    {"VT-425SOHAJ","VT-425 Sohaj",74},
    {"WEIHE50","Weihe 50",80},
    {"ZUGVOGELI","Zugvogel I",86},
    {"ZUGVOGELII","Zugvogel II",86},
    {"ZUGVOGELIIIA","Zugvogel III a",88},
    {"ZUGVOGELIIIB","Zugvogel IIIb",90},
    {"ZUGVOGELIV","Zugvogel IV",86},
    {"EOF","EOF", -1} // end marker
};

#endif
