/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qstring.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kdebug.h>

#include "aux.h"
#include "DDataItem.h"

#include "DDataControl.h"
#include "DissertParser.h"

URLObject tmpobj;

DissertParser::DissertParser(DDataControl*d) : QXmlDefaultHandler() 
{
	m_id = DItem::NOITEM;
	m_inItem = false;

	m_docversion  = 0;
	m_datacontrol = d;
}

bool DissertParser::startDocument()
{
	return true;
}

bool DissertParser::startElement( const QString&, const QString&, const QString& qName, const QXmlAttributes& attrs)
{
	if (qName == "item")
	{
		m_inItem = true;
	}
	else if (qName == "ref")
	{
		DDataItem *item = m_datacontrol->dataItem(m_id);
		int iddest = attrs.value("dest").toInt();
		//QString txt = attrs.value(1);
		m_datacontrol->requestRefChange( m_id, iddest, true, false);
	}
	else if (qName == "meta")
	{
		m_datacontrol->m_fname = attrs.value("fname");
		m_datacontrol->m_sname = attrs.value("sname");

		m_datacontrol->m_pixSize = attrs.value("pixsize").toInt();
		m_datacontrol->m_col_background.setNamedColor( attrs.value("colbackground") );
		m_datacontrol->m_col_link.setNamedColor( attrs.value("collink") );
		m_datacontrol->m_col_ref.setNamedColor( attrs.value("colref") );

		m_datacontrol->m_canvasFont.fromString( attrs.value("canvasfont") );
		m_datacontrol->m_picturesOnCanvas = (bool) attrs.value("picturesoncanvas").toInt();
		m_datacontrol->m_reverseVideo = (bool) attrs.value("reversevideo").toInt();

		m_datacontrol->m_showDirectionSize = attrs.value("showdirectionsize").toInt();
		m_datacontrol->m_linkstyle = attrs.value("linkstyle").toInt();
	}
	else if (qName == "link")
	{
		URLObject obj;
		obj.m_url = attrs.value("url");
		obj.m_caption = attrs.value("caption");

		DDataItem *item = m_datacontrol->dataItem(m_id);

		if (obj.m_url.length() || obj.m_caption.length())
			item->m_urllist.append( obj );
	}

	m_str = QString::null;
	return true;
}

bool DissertParser::endElement( const QString&, const QString&, const QString& qName )
{
	if (qName == "id")
	{
		m_id = m_str.toInt();
		m_datacontrol->createItemWithId( m_id );
	}
	else if (qName == "version")
	{
		m_docversion = m_str.toInt();
	}
	else if (m_datacontrol->isRegistered(m_id))
	{
		DDataItem *item = m_datacontrol->dataItem(m_id);

		if (qName == "xpos")
		{
			item->setXY( m_str.toInt(), item->y());
		}
		else if (qName == "ypos")
		{
			item->setXY( item->x(), m_str.toInt());
		}
		else if (qName == "parent")
		{
			item->setParent(m_str.toInt());
		}
		else if (qName == "child")
		{
			item->addChild(m_str.toInt());
		}
		else if (qName == "defaultfont")
		{
			item->m_defaultFont.fromString(m_str);
		}
		else if (qName == "colorscheme")
		{
			item->m_colorscheme = m_str.toInt();
		}
		else if (qName == "fillcolor")
		{
			item->m_fillcolor.setNamedColor(m_str);
		}
		else if (qName == "outlinecolor")
		{
			item->m_outlinecolor.setNamedColor(m_str);
		}
		else if (qName == "textcolor")
		{
			item->m_textcolor.setNamedColor(m_str);
		}
		else if (qName == "abstract" || qName == "text")
		{
			// provided for old files, automatic conversion to richtext
			if (! m_str.startsWith("<html>"))
			{
				item->m_text.append("<html>");
				item->m_text.append( DDataItem::protectXML( m_str ) );
				item->m_text.append("</html>");
			}
			else
			{
				item->m_text = m_str;
			}

			// old files did not have a summary
			if (item->m_summary == NULL)
				item->m_summary = item->m_text.left(50);
		}
		else if (qName == "summary" || qName == "title")
		{
			item->m_summary = m_str;
		}
		else if (qName == "comment" )
		{
			item->m_comment = m_str;
		}
		else if (qName == "url")
		{
			if (m_docversion < 1)
				item->m_picurl = m_str;
			else
				tmpobj.m_url = m_str;

		}
		else if (qName == "picurl")
		{
			item->m_picurl = m_str;
		}
		else if (qName == "piccaption" || qName == "legend" )
		{
			item->m_piccaption = m_str;
		}
		else if (qName == "urlcaption" )
		{
			tmpobj.m_caption = m_str;
			if (tmpobj.m_url.length() || tmpobj.m_caption.length())
				item->m_urllist.append( tmpobj );
		}
		else if (qName == "flag" )
		{
			item->m_flags.append( m_str.toInt() );
		}

		// going to next item
		else if (qName == "item")
		{
			m_inItem = false;
			m_id = DItem::NOITEM;
		}
	}
	/*    else if (qName != "kdissertdoc")
	      {
	      kdWarning()<<"BUG : item was not created : "<<qName<<" "<<m_str<<endl;
	      return false;
	      }*/

	return true;
}

bool DissertParser::characters( const QString& s)
{
	m_str = s;
	return true;
}

