/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qwidgetstack.h>

#include <kaction.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kkeydialog.h>
#include <klibloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <ktrader.h>

#include "kmathtool.h"
#include "kmathtoolview.h"
#include "kmtmodule.h"
#include "kmtmoduleiface.h"


KMathTool::KMathTool(QWidget* parent, const char* name)
  : KMainWindow(parent, name)
{
  m_view = new KMathToolView(this);
  setCentralWidget(m_view);

  setupActions( );

  setXMLFile("kmathtoolui.rc");
  createGUI( );

  iface = new ModuleInterface(this);

  connect(iface, SIGNAL(signalNoModules( )), this, SLOT(slotNoModules( )));
  connect(iface, SIGNAL(signalModuleLoaded(KMathToolModule*)),
    m_view, SLOT(slotIntegrateModule(KMathToolModule*)));

  iface->loadModules( );

  readConfig( );
}

bool KMathTool::queryExit( )
{
  writeConfig( );
  m_view->writeConfig( );
  return true;
}

void KMathTool::setupActions( )
{
  // File menu
  (void)KStdAction::quit(this, SLOT(close( )), actionCollection( ));

  // Settings menu
  (void)KStdAction::keyBindings(this, SLOT(slotConfigureKeys( )), actionCollection( ));

  // Help menu
  (void)new KAction(i18n("KMathTool &Introduction"), 0,
    m_view, SLOT(slotShowIntroduction( )), actionCollection( ), "help_intro");
}

void KMathTool::readConfig( )
{
  applyMainWindowSettings(KGlobal::config( ), "MainWindow");
}

void KMathTool::writeConfig( )
{
  saveMainWindowSettings(KGlobal::config( ), "MainWindow");
}

// *******************************
// ***** SLOT implementation *****
// *******************************
void KMathTool::slotNoModules( )
{
  KMessageBox::error(this, i18n("Could not find any modules. "
    "Please check your installation."), i18n("No Modules"));
}

void KMathTool::slotConfigureKeys( )
{
  KKeyDialog::configure(actionCollection());
}

#include "kmathtool.moc"
