#!/usr/bin/env kjscmd

// Populates the sidebar listview
function setup_sidebar( special, qt, kde, all )
{
    var qobjects = Factory.constructors().sort();

    for ( var i=0; i < qobjects.length ; i++ ) {
	all.insertItem( qobjects[i] );

	if ( /^Q/.test(qobjects[i]) )
	    qt.insertItem( qobjects[i] );
	else if ( /^K/.test(qobjects[i]) )
	    kde.insertItem( qobjects[i] );
	else
	    special.insertItem( qobjects[i] );
    }

    qt.insertItem( 'Qt' );
}

//
// Main
//

// Create the UI
var mw = new KMainWindow();
var ac = mw.actionCollection();

var split = new QSplitter( mw );
mw.setCentralWidget( split );

side = new QTabWidget( split, 'sidebar' );
view = new QTabWidget( split, 'mainview' );

// Load the view
jsview = Factory.createROPart( "text/html", view, "js" );
cppview = Factory.createROPart( "text/html", view, "cpp" );

js = view.child(4);
cpp = view.child(6);

view.addTab( js, '&Javascript' );
view.addTab( cpp, '&C++' );

view.set_class = function( clazz )
{
   var nm;

   clazz = clazz.replace( '^[^QK]*', '' );

   if ( /^Q/.test(clazz) )
      nm = 'http://doc.trolltech.com/3.2/' + clazz.toLowerCase() + '.html';
   else
      nm = 'http://developer.kde.org/documentation/library/cvs-api/kdeui/html/class' + clazz + '.html';

   cppview.openURL( nm );

   // JS docs
   jsview.openStream( 'text/html', 'file:///index.html' );
   jsview.writeStream( '<html>' );
   jsview.writeStream( '<head>' );
   jsview.writeStream( '<style type="text/css"><!--' );
   jsview.writeStream( 'h1 { text-align: center; background-color: #ccccff; }' );
   jsview.writeStream( 'h2 { background-color: #eeeeff; }' );
   jsview.writeStream( 'h3 { background-color: #eeeeff; }' );
   jsview.writeStream( 'th { background-color: #cccccc; }' );
   jsview.writeStream( 'td { background-color: #eeeeee; }' );
   jsview.writeStream( '--></style>' );
   jsview.writeStream( '</head>' );
   jsview.writeStream( '<body>' );
   jsview.writeStream( '<h1>' + clazz + '</h1>' );

   try {
     var obj = eval('new '+clazz+'()'); 
     jsview.writeStream( dump(obj) );
   }
   catch ( err ) {
     try {
	 var obj = eval(clazz); 
	 jsview.writeStream( dump(obj) );
     }
     catch ( err2 ) {
	 jsview.writeStream( '<font color="red">Error dumping object: ' + err + '<hr>' + err2 + '</font>' );
     }
   }

   jsview.writeStream( '</body>' );
   jsview.writeStream( '</html>' );
   jsview.closeStream();
}

view.setup = function()
{
  // JS docs
  jsview.openStream( 'text/html', 'file:///index.html' );
  jsview.writeStream( '<html>' );
  jsview.writeStream( '<head>' );
  jsview.writeStream( '<style type="text/css"><!--' );
  jsview.writeStream( 'h1 { text-align: center; background-color: #ccccff; }' );
  jsview.writeStream( 'h2 { background-color: #eeeeff; }' );
  jsview.writeStream( 'h3 { background-color: #eeeeff; }' );
  jsview.writeStream( '--></style>' );
  jsview.writeStream( '</head>' );
  jsview.writeStream( '<body>' );
  jsview.writeStream( '<h1>Script Reference</h1>' );
  jsview.writeStream( '</body>' );
  jsview.writeStream( '</html>' );
  jsview.closeStream();

  // C++ docs
  cppview.openStream( 'text/html', 'file:///index.html' );
  cppview.writeStream( '<html>' );
  cppview.writeStream( '<head>' );
  cppview.writeStream( '<style type="text/css"><!--' );
  cppview.writeStream( 'h1 { text-align: center; background-color: #ccccff; }' );
  cppview.writeStream( 'h2 { background-color: #ccccff; }' );
  cppview.writeStream( 'h3 { background-color: #ddddff; }' );
  cppview.writeStream( '--></style>' );
  cppview.writeStream( '</head>' );
  cppview.writeStream( '<body>' );
  cppview.writeStream( '<h1>C++ Reference</h1>' );
  cppview.writeStream( '</body>' );
  cppview.writeStream( '</html>' );
  cppview.closeStream();

  jsview.connect( jsview.child(0), 'openURLRequest(const KURL&,const KParts::URLArgs&)', 'openURL(const KURL&)' );
  cppview.connect( cppview.child(0), 'openURLRequest(const KURL&,const KParts::URLArgs&)', 'openURL(const KURL&)' );
}

// Setup the sidebar
specialside = new KListView( side, 'specialsidebar' );
specialside.addColumn( 'Class' );
specialside.resizeMode = 2; // LastColumn

specialside.changed = function()
{
    var item = this.selectedItem();
    view.set_class( item.text(0) );
}

qtside = new KListView( side, 'qtsidebar' );
qtside.addColumn( 'Class' );
qtside.resizeMode = 2; // LastColumn

qtside.changed = function()
{
    var item = this.selectedItem();
    view.set_class( item.text(0) );
}

kdeside = new KListView( side, 'kdesidebar' );
kdeside.addColumn( 'Class' );
kdeside.resizeMode = 2; // LastColumn

kdeside.changed = function()
{
    var item = this.selectedItem();
    view.set_class( item.text(0) );
}

allside = new KListView( side, 'allsidebar' );
allside.addColumn( 'Class' );
allside.resizeMode = 2; // LastColumn

allside.changed = function()
{
    var item = this.selectedItem();
    view.set_class( item.text(0) );
}

side.addTab( specialside, '&Special' );
side.addTab( kdeside, '&KDE' );
side.addTab( qtside, '&Qt' );
side.addTab( allside, '&All' );

setup_sidebar( specialside, qtside, kdeside, allside );

kdeside.connect( kdeside, 'selectionChanged()', kdeside, 'changed' );
qtside.connect( qtside, 'selectionChanged()', qtside, 'changed' );
specialside.connect( specialside, 'selectionChanged()', specialside, 'changed' );
allside.connect( allside, 'selectionChanged()', allside, 'changed' );

//
// Activate XMLGUI and show the window
//
StdAction.quit( mw, 'close()', mw.actionCollection() );

mw.createGUI( 'stdactionsui.rc' );
side.maximumWidth = 250;
mw.resize( 800, 550 );

mw.show();

//
// Connect together
//
view.setup();

application.exec();

