/***************************************************************************
                          devicesapplet.h  -  description
                             -------------------
    begin                : jeu jui 24 18:57:47 CEST 2003
    copyright            : (C) 2003 by ervin
    email                : ervin at tuxfamily dot org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEVICESAPPLET_H
#define DEVICESAPPLET_H

#ifdef HAVE_CONFIG_H
        #include <config.h>
#endif

#include <kpanelapplet.h>
#include <qstring.h>
#include <kconfig.h>
#include <kurl.h>
#include <kfileitem.h>
#include <kdirlister.h>

#include <qptrlist.h>
#include "devicebutton.h"
typedef QPtrList<DeviceButton> DeviceButtonList;


class DevicesApplet : public KPanelApplet
{
Q_OBJECT

public:
	DevicesApplet(const QString& configFile, Type t = Normal, int actions = 0,
	              QWidget *parent = 0, const char *name = 0);
	~DevicesApplet();

	int widthForHeight(int height) const;
	int heightForWidth(int width) const;
	void about();
	void preferences();

protected:
	void arrangeButtons();
	void resizeEvent(QResizeEvent *e);
	void positionChange(Position p);
	void reloadList();
	void loadConfig();
	void saveConfig();
	void mousePressEvent(QMouseEvent *e);

protected slots:
	void slotClear();
	void slotStarted(const KURL &url);
	void slotCompleted();
	void slotNewItems(const KFileItemList &entries);
	void slotDeleteItem(KFileItem *fileItem);
	void slotRefreshItems(const KFileItemList &entries);

private:
	KDirLister *mpDirLister;
	DeviceButtonList mButtonList;
	QStringList mExcludedTypesList;
	QStringList mExcludedList;
	KFileItemList mDevices;
};

#endif
