/***************************************************************************
                          dirsynchtreeviewitem.h  -  description
                             -------------------
    begin                : lr okt 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIRSYNCHTREEVIEWITEM_H
#define DIRSYNCHTREEVIEWITEM_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qcolor.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfiletreeviewitem.h>
//////////////////////////////////////////////////////////////////////
// KDE system include files
#include <time.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files

class KFileTreeView;
class KFileTreeBranch;
/**
  *@author Bjrn Sahlstrm
  */

class DirSynchTreeViewItem : public KFileTreeViewItem  {
public: 
	/** */
	DirSynchTreeViewItem( KFileTreeViewItem* parent , KFileItem* item, KFileTreeBranch* brnch );
	/** */
	DirSynchTreeViewItem( KFileTreeView* parent, KFileItem* item, KFileTreeBranch *brnch );
	/** */
	virtual ~DirSynchTreeViewItem();
	/** */
	void setCorrespondingMissing( bool b ) { m_correspondingMissing = b; repaint(); }
	/** */
	bool  correspondingMissing() const { return m_correspondingMissing; }
	/** */
	void setIsDifferent( bool b ) {m_isDifferent = b; repaint(); }
	/** */
	void setColors( const QColor& diff, const QColor& mRemote, const QColor& mLocal );
	/** */
	void setTimeDiff( int );
	/** */
	void setMissingAbove( bool m ) { m_missingAbove = m; }
	/** */
	void setMissingBelow( bool m ) { m_missingBelow = m; }
	/** */
	void setSelectedAbove( bool s ) { m_selectedAbove = s; }
	/** */
	void setSelectedBelow( bool s ) { m_selectedBelow = s; }
	/** */
	bool isDifferent() const { return m_isDifferent; }
	/** */
	time_t time( unsigned int which = KIO::UDS_MODIFICATION_TIME );
	/** */
	QString timeString( unsigned int which = KIO::UDS_MODIFICATION_TIME );
	/** */
	virtual void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
private:
	bool m_correspondingMissing;
	bool m_isDifferent;
	QColor m_diffColor;
	QColor m_missingRemoteColor;
	QColor m_missingLocalColor;
	bool m_missingAbove;
	bool m_missingBelow;
	bool m_selectedAbove;
	bool m_selectedBelow;
	int m_timeDiff;
};

#endif
