/***************************************************************************
                          kbearapplication.cpp  -  description
                             -------------------
    begin                : mn jan 14 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kcmdlineargs.h>
#include <kdesktopfile.h>
#include <kstartupinfo.h>
#include <dcopclient.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearapplication.h"
#include "kbearmdichildview.h"
#include "kbearsplash.h"
#include "kbear.h"
#include "resource.h"


//-----------------------------------------------
KBearApplication::KBearApplication()
	: m_isRunning( false )
{
	if( ! dcopClient()->isRegistered() ) {
		dcopClient()->attach();
		dcopClient()->registerAs( PACKAGE );
	}
	dcopClient()->setDefaultObject( objId() );
}
//-----------------------------------------------
KBearApplication::~KBearApplication(){
	kdDebug()<<"KBearApplication::~KBearApplication()"<<endl;
}
//-----------------------------------------------
int KBearApplication::newInstance() {
    // only to let klauncher not fail on a second instance of kbear ;)
	KStartupInfo::appStarted();

	KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

     QTimer timer;
	KBearSplash* splash = 0L;
	if( ! m_isRunning ) {
		m_isRunning = true;
	 	timer.start( 200, true );
		splash = new KBearSplash;
		splash->show();
		splash->raise();
		while( timer.isActive() ) 
			processEvents();
		timer.start( 2000, true );
		setMainWidget( KBear::self() );
		splash->raise();
     }
	KURL url;
	for(int i=0; i<args->count(); i++) {
		if( KDesktopFile::isDesktopFile( args->arg( i ) ) ) {
			KDesktopFile desktopFile( args->arg( i ) );
			url = desktopFile.readURL();
		}
		else
			url = args->url( i );
		openURL( url.url() );
	}
	args->clear();  // release memory

	while( timer.isActive() ) 
		processEvents();
     if( splash )
		delete splash;

	return 0;
}
//-----------------------------------------------
void KBearApplication::raiseMainWindow() {
	KBear::self()->raise();
}
//-----------------------------------------------
void KBearApplication::openURL( QString u ) {
	KURL url( u );
	if( url.protocol() == QString::fromLatin1( "ftp" ) )
		url.setProtocol( QString::fromLatin1( "kbearftp" ) );
	Connection connection( url );
	openConnection( connection );
}
//-----------------------------------------------
void KBearApplication::openConnection( Connection connection ) {
	KBear::self()->slotCreateClient( connection );
	KBear::self()->raise(); // make sure the app is visible
}
//-----------------------------------------------
DCOPRef KBearApplication::currentMdiChildView() {
	DCOPRef res;
 	KBearMdiChildView *view = static_cast<KBearMdiChildView*>(KBear::self()->activeWindow());	
	if( !view )
		return res;

	return DCOPRef( kapp->dcopClient()->appId(), view->objId() );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearapplication.moc"
#endif
