/***************************************************************************
                          kbearconnectionmanager.h  -  description
                             -------------------
    begin                : tor apr 18 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARCONNECTIONMANAGER_H
#define KBEARCONNECTIONMANAGER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/slave.h>
#include <kio/jobclasses.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "connection.h"
#include "transfer.h"
/**
	*There will always be only one instace of this class.
	*@author Bjrn Sahlstrm
*/

class KBearCopyJob;
#define connectionManager  KBearConnectionManager::self()


class KBearConnectionManager : public QObject  {
   Q_OBJECT
public: // Public methods
	/** */
	~KBearConnectionManager();
	/** */
	static KBearConnectionManager* self();
	/** No descriptions */
	KIO::Slave* openNewConnection( unsigned long ID, const Connection& connection, bool isDirLister = false );
	/** No descriptions */
	void closeConnection( unsigned long ID );
	/** No descriptions */
	void attachJob( unsigned long ID, KIO::SimpleJob* );
	/** No descriptions */
	void scheduleJob( unsigned long ID, KIO::SimpleJob* );
	/** No descriptions */
	KIO::Job* del( unsigned long ID, const KURL::List&, bool ,bool );
	/** No descriptions */
	KBearCopyJob* copy( Transfer* );
	/** No descriptions */
	KBearCopyJob* move( Transfer* );
	/** No descriptions */
	KBearCopyJob* copy( Transfer*, unsigned long sourceID, unsigned long destID );
	/** No descriptions */
	KBearCopyJob* move( Transfer*, unsigned long sourceID , unsigned long destID );
	/** No descriptions */
	void pauseJob( KIO::Job* job );
	/** No descriptions */
	void resumeJob( KIO::Job* job );
	/** No descriptions */
	KIO::Slave* getSlave( unsigned long ID );
	/** No descriptions */
	Connection* getConnection( unsigned long ID );
	/** No descriptions */
	void putOnHold( unsigned long ID );
	/** No descriptions */
	void jobStarting( unsigned long ID );
public slots:
	/** No descriptions */
	void slotCopyResult( KIO::Job* job );
	/** No descriptions */
	void slotSingleCopyResult( KIO::Job* job );
signals:
	/** No descriptions */
	void enableGUI( const QString&, bool );
	/** No descriptions */
	void jobPaused( KIO::Job* );
	/** No descriptions */
	void jobResumed( KIO::Job* );
	/** No descriptions */
	void slaveKilled( KIO::Slave* );
private slots: // Private slots
	void slotResetJob( KIO::Job* );
	void slotDeleteResult( KIO::Job* );
private: // Private
	unsigned long getIDForDirListerFromLabel( const QString& label );
	void setupCopyMove( Transfer*, KIO::Job*, unsigned long, unsigned long );
	void setupCopyMove( Transfer* transfer, KIO::Job* job );
	class ConnectionInfo;
	ConnectionInfo* createConnectionInfo( const Connection& conn, KIO::Slave* slave );
	KBearConnectionManager(const char* name="KBearConnectionManager");
	void attachJob( ConnectionInfo* info, KIO::SimpleJob* job );

	static KBearConnectionManager* s_connectionManager;
	typedef QMap<unsigned long, ConnectionInfo*> ConnectionMap;
	ConnectionMap m_connectionMap;
};

#endif
