/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef MEMSENSOR_H
#define MEMSENSOR_H
#include "sensor.h"
#include <qstring.h>
#include <qregexp.h>

class MemSensor :  public Sensor
{
Q_OBJECT
public:

  MemSensor( int interval );
  ~MemSensor();

  int getMemTotal();
  int getMemFree();
  int getBuffers();
  int getCached();

  int getSwapTotal();
  int getSwapFree();

  void update();
  void setMaxValue( SensorParams *sp );
  QString getMemLine();

private:
  QString meminfo;
  void readValues();
};

#endif // MEMSENSOR_H
