<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");

$new_date = date("Y-m-d H:i:s");
$DB = Config::Database();

$ID = $DB->nextId('networking__ID');
$vals = array(
	'ID' => $ID,
	'name' => $name,
	'type' => $type,
	'ram' => $ram,
	'ip' => $ip,
	'mac' => $mac,
	'location' => $location,
	'serial' => $serial,
	'otherserial' => $otherserial,
	'contact' => $contact,
	'contact_num' => $contact_num,
	'datemod' => $new_date,
	'comments' => $comments
	);
$DB->InsertQuery('networking', $vals);

for ($i = 1; $i <= $numports; $i++)
{
	$vals = array(
		'device_on' => $ID,
		'device_type' => 2,
		'iface' => $ifacetype,
		'ifaddr' => $ip,
		'ifmac' => $mac,
		'logical_number' => $i,
		'name' => "Port $i"
		);
	$DB->InsertQuery('networking_ports', $vals);
}
logevent($ID, "networking", 4, "database", printf(_("%s added record"), $IRMName));

header("Location: ".$_SESSION['_sess_prevpage']);
