// --------------------------------------------------------------------
// Debug window
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "debugwin.h"
#include "ipeq.h"

#include <qapplication.h>
#include <qpopupmenu.h>
#include <qmultilineedit.h>
#include <qmenubar.h>
#include <qstring.h>

// --------------------------------------------------------------------

//! Static singleton pointer.
DebugWindow *DebugWindow::This = 0;

//! Static pointer to debug stream;
IpeStream *DebugWindow::stream = 0;

DebugWindow::DebugWindow()
  : QMainWindow(0, "debug window", WDestructiveClose)
{
  iView = new QMultiLineEdit(this);
  // iView->setTextFormat(Qt::PlainText);
  iView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  iView->setReadOnly(true);

  setCentralWidget(iView);

  setCaption(tr("Ipe message output"));

  resize(640, 480);

  QPopupMenu* file = new QPopupMenu(this);
  file->insertItem(tr("&Close"), this, SLOT(close()), ALT|Key_W);
  menuBar()->insertItem(tr("&File"), file);
  statusBar();

  iView->setFocus();
}

void DebugWindow::Message(QString str)
{
  iView->insertLine(str);
  iView->setCursorPosition(iView->numLines(), 0);
}

DebugWindow::~DebugWindow()
{
  This = 0;
  stream = 0;
}

// --------------------------------------------------------------------

class IpeDebugStream : public IpeStream {
public:
  IpeDebugStream(DebugWindow *win) : iWindow(win) { /* none */ }
  void PutChar(char ch);
  void PutString(IpeString s);
  void PutCString(const char *s);
  void PutRaw(const char *data, int size);
private:
  IpeString iLine;
  DebugWindow *iWindow;
};

void IpeDebugStream::PutChar(char ch)
{
  if (ch == '\n') {
    ipeDebug(iLine.CString());
    iWindow->Message(QIpe(iLine));
    iLine.erase();
  } else
    iLine += ch;
}

void IpeDebugStream::PutString(IpeString s)
{
  for (int i = 0; i < s.size(); ++i)
    PutChar(s[i]);
}

void IpeDebugStream::PutCString(const char *s)
{
  if (s) {
    while (*s)
      PutChar(*s++);
  }
}

void IpeDebugStream::PutRaw(const char *data, int size)
{
  while (size--)
    PutChar(*data++);
}

// --------------------------------------------------------------------

// This is the public function

void DebugWindow::Show()
{
  (void) Stream(); // make sure it exists
  This->show();
  This->raise();
}

using namespace std;

IpeStream &DebugWindow::Stream()
{
  if (qApp) {
    // running with user interface
    if (!This)
      This = new DebugWindow();
    if (!stream)
      stream = new IpeDebugStream(This);
  } else {
    if (!stream)
      stream = new IpeFileStream(stderr);
  }
  return *stream;
}

// --------------------------------------------------------------------
