%{ /* -*- c -*- */

/*********************************************************************
 * Filename:      scanner.l
 * Version:       $Id: scanner.l,v 1.10 2002/09/23 01:52:33 tfheen Exp $
 * Description:   configuration lexer for intuitively
 * Author:        Tollef Fog Heen <tfheen@manon.intern.opera.no>
 * Created at:    Tue Oct 10 18:05:08 2000
 * Modified at:   Sun Jun 23 11:29:16 2002
 * Modified by:   Tollef Fog Heen <tollef@add.no>
 ********************************************************************/

#include "intuitively.h"
#include <string.h>
#include "parser.h"

%}

ws [ \r\t\n]+
comment #.*
id [a-zA-Z][-a-zA-Z0-9]*
hex [0-9A-Fa-f]
ipv4 [0-9]+\.[0-9]+\.[0-9]+\.[0-9]+
macaddress ({hex}{1,2}:){5}{hex}{1,2}
ipv6 {hex}+:({hex}+)?(:{hex}+)*
nl \n
path \/[a-zA-Z][a-zA-Z0-9/._-]+
netmask_str netmask

%%

{ws} ;
{comment} ;

myip { 
  /*  fprintf(stderr,"lex::myip\n"); */
  return MYIP;
};

[0123][0-9]+|255\.[0-9]+\.[0-9]+\.[0-9]+ {
  /*  fprintf(stderr,"netmask: %s\n",yytext); */
  yylval.string = strdup(yytext);
  return NETMASK;
};

{netmask_str} { return NETMASK_STR;}; 

other_mac { return OTHERMAC; };

other_ip { return OTHERIP;};

default_gw { return DEFAULT_GW; };

wireless_key { return WIRELESS_KEY; };

wireless_essid { return WIRELESS_ESSID; };

description { return DESCRIPTION; };

script { return SCRIPT; };

broadcast { return BROADCAST; };

dontsetip {
  return DONTSETIP;
}

defaultlocation {
  return DEFAULTLOCATION;
}

{macaddress} {
  yylval.string = strdup(yytext);
  return MACADDRESS;
}

{ipv4} {
  yylval.string = strdup(yytext);
  /*  printf("ip: %s\n",yytext);  */
  return IPV4;
};

{ipv6} {
  yylval.string = strdup(yytext);
  /*  printf("ip: %s\n",yytext);  */
  return IPV6;
};

{id} {
  yylval.string = strdup(yytext);
  return ID;
};

{path} {  
  yylval.string = strdup(yytext);
  return PATH;
};

{hex}+ {
  yylval.string = strdup(yytext);
  return HEX;
};

. {
  return yytext[0];
};

%%
int yyerror(char* msg) {
  fprintf(stderr, "error: %s at %s\n",msg,yytext);
  return -1;
}
