/***************************************
  $Header: /cvsroot/petscgraphics/illuminator.h,v 1.22 2004/08/17 15:05:42 hazelsct Exp $

  This is the interface for the Illuminator library.
***************************************/

#ifndef ILLUMINATOR_H
#define ILLUMINATOR_H    /*+ To stop multiple inclusions. +*/
#include <petscda.h>
#include <glib.h>

/*+ A value of
  +latex+{\tt field\_plot\_type}
  +html+ <tt>field_plot_type</tt>
  is attached to each field in a simulation in order to visualize them
  properly.  Types are as follows:
  +*/
typedef enum {
  /*+Scalar field.+*/
  FIELD_SCALAR                    = 0x00,
  /*+Ternary composition field with two components (third component is inferred
    from first two).+*/
  FIELD_TERNARY                   = 0x10,
  /*+Vector field.+*/
  FIELD_VECTOR                    = 0x20,
  /*+Full ds*ds tensor field, e.g. transformation.+*/
  FIELD_TENSOR_FULL               = 0x30,
  /*+Symmetric tensor field (using lines in principal stress directions).+*/
  FIELD_TENSOR_SYMMETRIC          = 0x38,
  /*+Symmetric tensor field, inferring last diagonal from the opposite of the
    sum of the others.+*/
  FIELD_TENSOR_SYMMETRIC_ZERODIAG = 0x39
} field_plot_type;

/* Core stuff in illuminator.c */
int IllDrawTet (PetscScalar *coords, PetscScalar *vals, PetscScalar isoquant,
		PetscScalar *color);
int IllDrawHex (PetscScalar *coords, PetscScalar *vals, PetscScalar isoquant,
		PetscScalar *color);
int IllDraw3DBlock
(int xd, int yd, int zd, int xs, int ys, int zs, int xm, int ym, int zm,
 PetscScalar *minmax, PetscScalar *vals, int skip,
 int n_quants, PetscScalar *isoquants, PetscScalar *colors);

/* Utility stuff in utility.c */
int minmax_scale
(PetscScalar *global_array, int points, int num_fields, int display_field,
 field_plot_type fieldtype, int dimensions, PetscScalar *minmax);
void field_indices (int nfields, int ds, field_plot_type *plottypes,
		    int *indices);

/* PETSc stuff; xcut, ycut and zcut should almost always be PETSC_FALSE */
int DATriangulateRange
(DA theda, Vec globalX, int this, PetscScalar *minmax, int n_quants,
 PetscScalar *isoquants, PetscScalar *colors, int xmin,int xmax, int ymin,
 int ymax, int zmin,int zmax);
int DATriangulateLocalRange
(DA theda, Vec localX, int this, PetscScalar *minmax, int n_quants,
 PetscScalar *isoquants, PetscScalar *colors, int xmin,int xmax, int ymin,
 int ymax, int zmin,int zmax);
static inline int DATriangulate
(DA theda, Vec globalX, int this, PetscScalar *minmax, int n_quants,
 PetscScalar *isoquants, PetscScalar *colors, PetscTruth xcut, PetscTruth ycut,
 PetscTruth zcut)
{ DATriangulateRange (theda, globalX, this, minmax, n_quants, isoquants,
		      colors, 0,xcut?-2:-1, 0,ycut?-2:-1, 0,zcut?-2:-1); }
static inline int DATriangulateLocal
(DA theda, Vec localX, int this, PetscScalar *minmax, int n_quants,
 PetscScalar *isoquants, PetscScalar *colors, PetscTruth xcut, PetscTruth ycut,
 PetscTruth zcut)
{ DATriangulateLocalRange (theda, localX, this, minmax, n_quants, isoquants,
			   colors, 0,xcut?-2:-1, 0,ycut?-2:-1, 0,zcut?-2:-1); }
int IllErrorHandler (int id, char *message);

/* Plotting functions to render data into an RGB buffer */
int render_rgb_local_2d
(guchar *rgb, int rwidth, int rheight, int bytes_per_pixel,
 PetscScalar *global_array, int num_fields, int display_field,
 field_plot_type fieldtype, PetscScalar *minmax, int nx,int ny, int xs,int ys,
 int xm,int ym);
int render_rgb_local_3d
(guchar *rgb, int rwidth, int rheight, int bytes_per_pixel,
 int num_triangles, PetscScalar *vertices,
 PetscScalar *eye, PetscScalar *dir, PetscScalar *right);

/* IlluMulti load/save stuff, including compression #defines */
int IlluMultiLoad
(char *basename, DA *theda, PetscScalar *wx,PetscScalar *wy,PetscScalar *wz,
 field_plot_type **fieldtypes, int *usermetacount, char ***usermetanames,
 char ***usermetadata);
int IlluMultiRead (DA theda, Vec X, char *basename, int *usermetacount, 
		   char ***usermetanames, char ***usermetadata);
int IlluMultiSave
(DA theda, Vec X, char *basename, PetscScalar wx,PetscScalar wy,PetscScalar wz,
 field_plot_type *fieldtypes, int usermetacount, char **usermetanames,
 char **usermetadata, int compressed);
#define COMPRESS_INT_MASK  0x30
#define COMPRESS_INT_NONE  0x00
#define COMPRESS_INT_LONG  0x10
#define COMPRESS_INT_SHORT 0x20
#define COMPRESS_INT_CHAR  0x30
#define COMPRESS_GZIP_MASK 0x0F
#define COMPRESS_GZIP_NONE 0x00
#define COMPRESS_GZIP_FAST 0x01
#define COMPRESS_GZIP_BEST 0x0A

/* Geomview stuff */
int GeomviewBegin (MPI_Comm comm);
int GeomviewEnd (MPI_Comm comm);
int GeomviewDisplayTriangulation (MPI_Comm comm, PetscScalar *minmax,
				  char *name, PetscTruth transparent);

#endif /* ILLUMINATOR_H */
