/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XDesktopContainer.h
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#ifndef XDESKTOP_CONTAINER_CLASS
#define XDESKTOP_CONTAINER_CLASS

#include "DesktopContainer.h"
#include "DesktopConfig.h"
#include "ActionConfig.h"
#include <X11/Xlib.h>
#include <Imlib.h>
#include <sys/wait.h>

class XIcon;

class XDesktopContainer : public DesktopContainer
{
    protected:
        Display* display;
        Window rootWindow;

        ImlibData * imlibData;
        ImlibImage * spareRoot;

        XEvent event;

        unsigned int time[3];
        unsigned int numClicks[3];
    public:
        XDesktopContainer(AbstractApp * a);
        ~XDesktopContainer();
        
        void run();
        void parseEvent();

        void initXWin();
        void initImlib();
        void configure();

        void addIcon(AbstractIcon *);
        void addXIcon(const string & file, const string & pictureFile,
                      const string & captionText, const string & command,
                      int xCord, int yCord,
                      const string & fontName, int fontSize, const string & color,
                      ImlibData * imlibData, ImlibImage * spareRoot);

        void eventLoop();
        void parseNonIconEvents();
        XIcon * parseIconEvents();
        void exeCurrentAction(XIcon * icon);

        virtual void setEventState();
        virtual void translateButtonRelease(int button);
        
        void saveState();
        void saveIcon(AbstractIcon *);
        void reloadState();

        Display * getDisplay() { return display; }
        Window getRootWindow() { return rootWindow; }
        ImlibData * getImlibData() { return imlibData; }
        ImlibImage * getSpareRoot() { return spareRoot; }

        void loadIcons();
        void arrangeIcons();
        XIcon * findIcon(Window window);
        void addIcon( const string & file, const string & pictureFile,
                      const string & captionText, const string & command, 
                      int xCord, int yCord ) ;

        void runCommand(const string & command);

        virtual int widthOfScreen();
        virtual int heightOfScreen();
};

#include "XIcon.h"

#endif
