/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

////////////////////////////////////////////////////
// IceFileSearch.h 
// class IceFileSearch manages searching for and in 
// files and directories
// created: mig 000911
///////////////////////////////////////////////////

#ifndef ICEFILESEARCH_H
#define ICEFILESEARCH_H

#include "IceMC.h"

#include <qfileinfo.h>

class IceFileSearch
{
 public:
  IceFileSearch();
  virtual ~IceFileSearch();
  virtual QString fileReadable(QString name, QString path=0);
  virtual QString fileExecutable(QString name, QString path=0);
  virtual QString dirReadable(QString name, QString path=0);
  virtual QString iconReadable(QString name, QString path=0);
  virtual QString getArgument(QString file, QString param);
 protected:
  virtual QString lookupExecutable(QString name, const QString path=0);
  virtual QString lookupFile(QString name, const QString path=0, bool dir=false);
  // data
  QFileInfo* fInfo;
};

// TODO: implement methods for searching arguments of parameters in files

#endif
