/*
//
// image.c
//
// Image file functions
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#include "htp.h"

#include "gif.h"
#include "jpeg.h"
#include "png.h"

typedef struct {
    BOOL (*checkFormat) (FILE * file);
    BOOL (*readDimensions) (FILE * file, DWORD *height, DWORD *width);
} ImageOps;

ImageOps ops[] = {
    { GifFormatFound , GifReadDimensions  },
    { JpegFormatFound, JpegReadDimensions },
    { PngFormatFound , PngReadDimensions  }
};

#define IMAGE_TYPE_COUNT (sizeof(ops) / sizeof(ImageOps))
#define IMAGE_TYPE_UNKNOWN IMAGE_TYPE_COUNT

BOOL OpenImageFile(const char *filename, IMAGEFILE *imageFile)
{
    uint type;
    assert(filename != NULL);
    assert(imageFile != NULL);

    /* open the file to make sure its reachable */
    if((imageFile->file = fopen(filename, "rb")) == NULL)
    {
        DEBUG_PRINT(("could not open image file %s", filename));
        return FALSE;
    }

    /* build the rest of the image file structure */
    if((imageFile->name = DuplicateString(filename)) == NULL)
    {
        DEBUG_PRINT(("could not duplicate filename string"));
	fclose(imageFile->file);
        return FALSE;
    }

    /* by default, unknown image type */
    for (type = 0; type < IMAGE_TYPE_COUNT; type++) {
	if (ops[type].checkFormat(imageFile->file))
	    break;
    }

    /* If type is unknown, the variable type is already
     * IMAGE_TYPE_COUNT == IMAGE_TYPE_UNKNOWN.
     */
    imageFile->imageType = type;
    return TRUE;
}   

void CloseImageFile(IMAGEFILE *imageFile)
{
    assert(imageFile != NULL);
    assert(imageFile->name != NULL);
    assert(imageFile->file != NULL);

    FreeMemory(imageFile->name);
    fclose(imageFile->file);

    imageFile->name = NULL;
    imageFile->file = NULL;
}   

BOOL GetImageDimensions(IMAGEFILE *imageFile, DWORD *width, DWORD *height)
{
    assert(imageFile != NULL);
    assert(width != NULL);
    assert(height != NULL);

    /* unknown file type */
    if(imageFile->imageType == IMAGE_TYPE_UNKNOWN)
	return FALSE;

    return ops[imageFile->imageType].readDimensions(imageFile->file, 
						    height, width);
}   

