/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
//
// html.h
//
// HTML markup tag functions
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#ifndef MARKUP_H
#define MARKUP_H

#define MAX_ATTRIBUTE_COUNT     (32)

typedef struct tagHTML_ATTRIBUTE
{
    char        *name;
    char        *value;
    BOOL        quoted;
} HTML_ATTRIBUTE;

typedef struct tagHTML_MARKUP
{
    char        *tag;
    uint        attribCount;
    BOOL        single; /* single tag (xml-style) ending with "/>" */
    HTML_ATTRIBUTE attrib[MAX_ATTRIBUTE_COUNT];
} HTML_MARKUP;

/*
// functions
*/

/* whitespace functions are not specific to markup tags, but commonly used */
const char *FindWhitespace(const char *str);
const char *FindNonWhitespace(const char *str);

/* HTML_ATTRIBUTE functions */
BOOL MakeAttribute(HTML_ATTRIBUTE *htmlAttribute, const char *name,
    const char *value, BOOL quoted);
BOOL ChangeAttributeName(HTML_ATTRIBUTE *htmlAttribute, const char *name);
BOOL ChangeAttributeValue(HTML_ATTRIBUTE *htmlAttribute, const char *value,
    BOOL quoted);
void DestroyAttribute(HTML_ATTRIBUTE *htmlAttribute);

/* HTML_MARKUP functions */
BOOL PlaintextToMarkup(const char *plaintext, HTML_MARKUP *htmlMarkup);
BOOL MarkupToPlaintext(HTML_MARKUP *htmlMarkup, char **plaintext);
BOOL AddAttributeToMarkup(HTML_MARKUP *htmlMarkup, const char *name,
    const char *value, BOOL quoted);
void DestroyMarkupStruct(HTML_MARKUP *htmlMarkup);
BOOL IsMarkupTag(HTML_MARKUP *htmlMarkup, const char *tag);
BOOL IsAttributeInMarkup(HTML_MARKUP *htmlMarkup, const char *name);
const char *MarkupAttributeValue(HTML_MARKUP *htmlMarkup, const char *name);
BOOL ChangeMarkupTag(HTML_MARKUP *htmlMarkup, const char *tag);
const HTML_ATTRIBUTE *MarkupAttribute(HTML_MARKUP *htmlMarkup, uint index);

#endif

