#include "dtutils.h"

#include <algorithm>
#include <iostream>
#include <list>
#include <map>
#include <cstdio>

bool isAbsolute(const string& s){
  return (s[0]=='/')||(find(s.begin(),s.end(),':')!=s.end());
}

string PathPart(string fname){
  string::iterator pos;
  if (fname.empty()) return string();
  for (pos=fname.end();(--pos!=fname.begin())&&(*pos!='/'););
  if ((pos==fname.begin())&&(*pos!='/')) return string();
  return string(fname.begin(),++pos);
}

string IToS(int val){
  char temp[16];
  sprintf(temp,"%d",val);
  return temp;
}

string FToS(float val){
  char temp[32];
  sprintf(temp,"%f",val);
  return temp;
}

string FilePart(string fname){
  string::iterator pos;
  if (fname.empty()) return string();
  for (pos=fname.end();(--pos!=fname.begin())&&(*pos!='/'););
  if ((pos!=fname.end())&&(*pos=='/')) ++pos;
  return string(pos,fname.end());
}

string escape(string data){
  string temp;
  for(string::iterator i=data.begin();i!=data.end();++i){
    if(*i==' '){
      temp+='+';
    }else if((*i>='A' && *i<='Z')||(*i>='a' && *i<='z')||(*i>='0' && *i<='9')||(*i=='.')||(*i=='-')||(*i=='_')){
      temp+=*i;
    }else{
      char enc[4];
      sprintf(enc,"%%%02X",*i & 0xFF);
      temp+=enc;
    }
  }
  return temp;
}

string unescape(string urlEncoded) {
  replace(urlEncoded.begin(),urlEncoded.end(),'+',' ');
  string result;
  string::iterator start =urlEncoded.begin();
  char digits[3];
  digits[2]=0;
  string::iterator index=find(start,urlEncoded.end(),'%');
  while(urlEncoded.end()!=index) {
    result.append(start,index);
    if ((index!=urlEncoded.end())&&(++index!=urlEncoded.end())) {
      digits[0]=*index;
      if (++index!=urlEncoded.end()) {
        digits[1]=*index;
      }
    }
    result+=strtol(digits,NULL,16);
    if (index!=urlEncoded.end()) start=++index;
    index=find(start,urlEncoded.end(),'%');
  }
  result.append(start,index);
  return result;
}

/*string RemoveQuotes(const string& text){
  if(text.length()<2) return text;
  string::const_iterator a=text.begin();
  string::const_iterator b=text.end();
  ++a;
  --b;
  if((*a=='\'' && *b=='\'')||(*a=='"' && *b=='"')){
    return string(a,b);
  }
  return text;
}*/

int global_replace(string& st,const string& find,
  const string& rep){
  int len=find.length(),count=0;
  string temp;
  string::const_iterator pos,first=st.begin(),last=st.end();
  do{
    pos=search(first,last,find.begin(),find.end());
    temp.append(first,pos);
    if(pos==last) break;
    ++count;
    temp.append(rep.begin(),rep.end());
    first=pos+len;
  }while(pos!=last);
  st=temp;
  return count;
}

string EscapeSignificant(string text){
  global_replace(text,">","&gt;");
  global_replace(text,"<","&lt;");
  global_replace(text,"\"","&quot;");
  global_replace(text,"'","&#39;");
  return text;
}
