/***************************************************************************
                         xhtmlgenerator.h  -  description
                             -------------------
    begin                : Mo Jun 21 2004
    copyright            : (C) 2004 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef XHTMLGENERATOR_H
#define XHTMLGENERATOR_H

#include "htmlgenerator.h"

namespace highlight {

/**
   \brief This class generates XHTML.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/


class XHtmlGenerator : public highlight::HtmlGenerator
  {
  public:

    /** Constructor
     \param colourTheme Name of Colour theme to use
     \param cssInFilename Path of file to be included in cssOutFilename
     \param cssOutFilename Path of external CSS stylesheet
     \param includeCssDef Test if CSS should be included in outfile
     \param withAnchors Test if HTML anchors should be attached to line numbers
    */
    XHtmlGenerator(const string &colourTheme,
                   const string &cssInFilename="",
                   const string &cssOutFilename="",
                   bool includeCssDef=false,
                   bool withAnchors = false);

    XHtmlGenerator();

    /** Destructor*/
    virtual ~XHtmlGenerator() {};

    /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string &title);

  };

}

#endif
