/* $Log: mudlle.c,v $
/* Revision 1.2  2004/10/25 16:36:08  emery
/* Ritual update.
/*
/* Revision 1.1  2003/10/15 15:58:58  emery
/* Initial check-in.
/*
/* Revision 1.2  2003/05/08 21:42:29  emery
/* Ritual check-in.
/*
/* Revision 1.1  2001/08/23 17:20:05  emery
/* The big fig newton.
/*
/* Revision 1.2  2001/06/29 21:22:57  dgay
/* Minor fixes, add README and COPYRIGHT files.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:18  dgay
/* Initial import of RC tests
/*
 * Revision 1.17  1997/08/04 22:17:08  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.16  1996/02/09 14:58:39  arda
 * Security holes
 *
 * Revision 1.15  1995/07/15  15:24:34  arda
 * Context cleanup.
 * Remove GCDEBUG.
 *
 * Revision 1.14  1995/01/22  15:11:46  arda
 * Linux patches.
 *
 * Revision 1.13  1994/10/09  06:42:40  arda
 * Libraries
 * Type inference
 * Many minor improvements
 *
 * Revision 1.12  1994/09/16  13:07:14  arda
 * Rename protect to catch.
 * New protect/unprotect functions (like dynpro/undynpro).
 *
 * Revision 1.11  1994/09/15  19:46:43  arda
 * Performance improvements:
 *   setjmp -> _setjmp (setjmp is horrendously slow)
 *   cold_protect
 * reset_limits split from reset_interpreter
 * fix division of negative numbers
 * Add ?\{n,r,t}
 * gc_size returns "mutable" size
 *
 * Revision 1.10  1994/08/26  08:51:43  arda
 * Keep free block list for string ports.
 *
 * Revision 1.9  1994/08/22  18:03:01  arda
 * Minor fixes.
 *
 * Revision 1.8  1994/08/17  16:29:57  arda
 * Seclevel fixes.
 *
 * Revision 1.7  1994/08/16  19:16:06  arda
 * Mudlle compiler for sparc now fully functional (68k compiler now needs
 * updating for primitives).
 * Changes to allow Sparc trap's for runtime errors.
 * Also added flags to primitives for better calling sequences.
 *
 * Revision 1.4  1994/02/24  08:33:00  arda
 * Owl: New error messages.
 *
 * Revision 1.3  1994/01/29  19:50:34  dgay
 * Owl: add file & line information to functions.
 *
 * Revision 1.2  1993/11/27  11:29:02  arda
 * Owl: Major changes to affect.
 *      Save mudlle data with players & objects.
 *      Change skill format on disk.
 *      Other minor changes.
 *      Still needs full debugging.
 *
 * Revision 1.1  1993/07/21  20:36:53  un_mec
 * Owl: Added &&, ||, optimised if.
 *      Added branches to the intermediate language.
 *      Separated destiniation language generation into ins module
 *      (with some peephole optimisation)
 *      Standalone version of mudlle (mkf, runtime/mkf, mudlle.c) added to CVS
 *
 */

static char rcsid[] = "$Id: mudlle.c,v 1.2 2004/10/25 16:36:08 emery Exp $";

#include <stdio.h>

#ifndef _WIN32
#include <unistd.h>
#endif

#include "mudlle.h"
#include "mparser.h"
#include "lexer.h"
#include "compile.h"
#include "mvalues.h"
#include "alloc.h"
#include "global.h"
#include "print.h"
#include "utils.h"
#include "module.h"
#include "mcompile.h"
#include "call.h"
#include "interpret.h"
#include "runtime/runtime.h"

extern FILE *yyin;
int debug_level = 0;

int load_file(char *name, char *nicename, int seclev, int reload)
{
  FILE *f;
  value result;
  int ok;

//  printf ("LOADING %s\n", name);

  if (!(f = fopen(name, "r"))) {
    printf ("CRAP!\n");
    runtime_error(error_bad_value);
  }

  read_from_file(f, nicename);
  ok = interpret(&result, seclev, reload);
  fclose(f);

  return ok;
}

struct pload
{
  char *name;
  char *nicename;
  int seclev, reload;
  int result;
};

static void pload(void *_data)
{
  struct pload *data = _data;

  data->result = load_file(data->name, data->nicename, data->seclev, data->reload);
}

int catch_load_file(char *name, char *nicename, int seclev, int reload)
{
  struct pload data;

  data.name = name; data.nicename = nicename; data.seclev = seclev;
  data.reload = reload;
  if (mcatch(pload, &data, TRUE)) return data.result;
  else return FALSE;
}

static void execute(char *line)
{
  value result;

  read_from_string(line);
  if (interpret(&result, 1, TRUE))
    {
      printf("Result: ");
      mprint(mudout, prt_print, result);
      printf("\n");
    }
}

main(int argc, char **argv)
{
#ifndef _WIN32
  //  char *sb = sbrk(0);
#endif
  char line[512];
  struct session_context context;
  struct oport *out;

#ifdef STATS
  setbuf(stdout, NULL);
  setbuf(stderr, NULL);
#endif
#ifdef BWGC
   {
     extern unsigned long GC_free_space_divisor;
     extern int GC_dont_expand;

     if (argc > 1 && strcmp(argv[1], "noexpand") == 0)
       {
	 GC_dont_expand = 1;
	 printf("no expand\n");
       }

     if (argc > 1 && strncmp(argv[1], "fsd", 3) == 0)
       {
	 GC_free_space_divisor = atoi(argv[1] + 3);
	 printf("fsd %d\n", GC_free_space_divisor);
	 argv++; argc--;
       }
   }
#endif
#ifdef TIMING
   timing_init();
#endif

  garbage_init();
  global_init();
  print_init();
  stack_init();
  module_init();
  runtime_init();
  parser_init();
  compile_init();
  mcompile_init();
  interpret_init();
  error_init();
  ports_init();
  context_init();

  out = make_file_outputport(stdout);
  session_start(&context, 0, 0, out, out);
  do
    {
#ifdef BWGC
      fprintf(stderr, "heap size %d\n", GC_get_heap_size());
#else
#ifndef _WIN32
      //      fprintf(stderr, "current sbrk use %d\n", (char *)sbrk(0) - sb);
#endif
#endif
      printf("mudlle> ");
      if (!gets(line)) break;
      execute(line);
    }
  while (1);
  session_end();
}
