#!/usr/local/bin/perl

use strict;

my $graphtitle = "passive-false runtimes";

my @namelist = ("hoard","ptmalloc","ptmalloc2","mtmalloc");
my %names;

$names{"hoard"} = "Hoard";
$names{"ptmalloc"} = "ptmalloc";
$names{"ptmalloc2"} = "ptmalloc2";
$names{"mtmalloc"} = "mtmalloc";
$names{"Solaris"} = "Solaris";

# my @namelist = ("hoard","ptmalloc","ptmalloc2","mtmalloc","Solaris");

my $name;
my %datapoint;

foreach $name (@namelist) {
    open G, "> Results/$name/data";
    for (my $i = 1; $i <= 16; $i++) {
	open F, "Results/$name/cache-scratch-$i";
	my $total = 0;
	my $count = 0;
	my $min = 1e30;
	my $max = -1e30;
	while (<F>) {
	    chop;
	    if (/([0-9]+\.[0-9]+) seconds/) {
		# print G "$i\t$1\n";
		my $current = $1;
		$total += $1;
		$count++;
		if ($current < $min) {
		    $min = $current;
		}
		if ($current > $max) {
		    $max = $current;
		}
	    }
	}
	my $avg = $total / $count;
	print G "$i\t$avg\t$min\t$max\n";
	close F;
    }
    close G;
}

open PLOT, "|gnuplot";
print PLOT "set term postscript\n";
print PLOT "set output \"foo.ps\"\n";
print PLOT "set title \"$graphtitle\"\n";
print PLOT "set ylabel \"Runtime (seconds)\"\n";
print PLOT "set xlabel \"Number of threads\"\n";
print PLOT "set xrange [0:17]\n";
print PLOT "plot ";

foreach $name (@namelist) {
    # next if ($name eq $namelist[-1]);
    print "name = $name\n";
    my $titlename = $names{$name};
    print PLOT "\"Results/$name/data\" title \"$titlename\" with errorbars, ";
}
# $name = $namelist[-1];
print PLOT "\"Results/hoard/data\" notitle with lines\n";
close PLOT;


