#ifndef _LOGHEAP_H_
#define _LOGHEAP_H_

#include "dbutil.h"

template<class SuperHeap>
class LogHeap : public SuperHeap {
  public:
	inline void * malloc(size_t size) {
		num_malloc++;

		dbprintf("[log] malloc(%d)", size);

		if (inside) {
			dbprintf("reentrant\n");
			assert(false);
		}
		inside = 1;
		void * ptr = SuperHeap::malloc(size);
		//dbprintf("Leaving #%d malloc(%d)=%p\n", num_malloc, size, ptr);
		inside = 0;
		objects_in_use++;

		dbprintf(" returns %p", ptr);
		dbprintf(" with size %d\n", getSize(ptr));

		return ptr;
	}

	inline void free(void * ptr) {
		objects_in_use--;

		dbprintf("[log] free(%p)", ptr);
		dbprintf(" with size %d", getSize(ptr));

		if (inside) {
			dbprintf("reentrant\n");
			assert(false);
		}
		inside = 1;
		SuperHeap::free(ptr);
		//dbprintf("Leaving #%d free(%p)\n", num_free, ptr);
		inside = 0;

		dbprintf(" returns OK\n");
	}
  private:
	static int inside;
	static size_t num_malloc;
	static size_t objects_in_use;
};	//end of class LogHeap

template<class SuperHeap>
int LogHeap<SuperHeap>::inside = 0;
template<class SuperHeap>
size_t LogHeap<SuperHeap>::num_malloc = 0;
template<class SuperHeap>
size_t LogHeap<SuperHeap>::objects_in_use = 0;

#endif
