/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "db.h"
#include "preferences.h"
#include "gui_utils.h"

GtkWidget *window;
sqlite *db;
statestype state;

extern preferencestype preferences;

static void
dircheck (void)
{
	struct stat statdir;
	gchar *mddir;
																																								
	mddir = g_strdup_printf ("%s%s.%s", 
		g_get_home_dir (), G_DIR_SEPARATOR_S, PACKAGE);
	if (stat (mddir, &statdir) == -1)
	{
		if (mkdir (mddir, S_IRUSR | S_IWUSR | S_IXUSR) == -1)
			g_error (_("Creating ~/.%s directory."), PACKAGE);
	}
	else if (!S_ISDIR (statdir.st_mode))
		g_error (_("~/.%s is not a directory."), PACKAGE);
}

/* limit length of textviews to 220 characters */
void text_changed (GtkTextBuffer *textbuffer, gpointer user_data)
{
	GtkTextIter first, last, start, stop;
	gchar *text;
	GtkTextMark *mark;

	gtk_text_buffer_get_start_iter (textbuffer, &first);
	gtk_text_buffer_get_end_iter (textbuffer, &last);
	text = gtk_text_buffer_get_text (textbuffer, &first, &last, FALSE);
	if (strlen(text) == 220)
	{
		mark = gtk_text_buffer_get_insert (textbuffer);
		gtk_text_buffer_get_iter_at_mark (textbuffer, &stop, mark);
		start = stop;
		gtk_text_iter_backward_chars (&start, 1);
		gtk_text_buffer_delete (textbuffer, &start, &stop);
		gdk_beep ();
	}
}
																																						
int
main (int argc, char *argv[])
{
	GtkWidget *entry, *notes, *spotnotes, *identry;
	gchar *filename, *err, *id;
	gint result;
	GtkTextBuffer *buffer;

	dircheck ();
	filename = g_strdup_printf ("%s%s.%s%sdb", 
		g_get_home_dir (), G_DIR_SEPARATOR_S, PACKAGE, G_DIR_SEPARATOR_S);

	db = sqlite_open(filename, 0, &err);
	if (!db)
	{
		g_print (_("Failed to open database '%s'.\n%s"), filename, err);
		return -1;
	}

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (PACKAGE, "UTF-8");
	textdomain (PACKAGE);
#endif

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
	window = create_window ();
	
	loadpreferences ();
	state.loaddir = g_strconcat (g_get_home_dir(), G_DIR_SEPARATOR_S, NULL);

	/* fill in combo strings */
	set_combostrings ();

	/* see if we can read a record. If not, create the database and add 1 record. */
	clearall ();
	identry = lookup_widget (window, "identry");
	entry = lookup_widget (window, "entry");
	gtk_entry_set_text (GTK_ENTRY (entry), "1");
	result = load_from_db (1);
	if (result == SQLITE_ERROR)
	{
		create_db ();
		result = add_to_db ();
		id = g_strdup_printf ("%d", result);
		gtk_entry_set_text (GTK_ENTRY(identry), id);
		g_free (id);
	}

	notes = lookup_widget (window, "notes");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (notes));
	g_signal_connect (G_OBJECT (buffer), "changed", G_CALLBACK (text_changed), NULL);
	spotnotes = lookup_widget (window, "spotnotes");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (spotnotes));
	g_signal_connect (G_OBJECT (buffer), "changed", G_CALLBACK (text_changed), NULL);
/* uncomment next for debugging purposes */
	gtk_widget_hide (identry);

	gtk_widget_show (window);

	gtk_main ();
	return 0;
}

