
//
// $Id: str.cc,v 1.1.1.1 2000/11/29 13:21:08 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/utils/str.cc,v $
// $Revision: 1.1.1.1 $
// $Date: 2000/11/29 13:21:08 $
// $State: Exp $
//
// Author: Geoff Wong
//
/*
 * Some string support routines
 */
#include <stdio.h>
#include <stdlib.h>

#include "str.h"

#define MAXTMP 256 

char * string_copy(const char * s)
{
	char * ret;
	ret = new char[strlen(s)+1];
	strcpy(ret,s);
	return ret;
}

/* 256 should be long enough for any integer we're printing! */
String itoa(int x)
{
	char tmp[MAXTMP];
	sprintf(tmp, "%d", x);
	String out(tmp);
	return out;
}

/* 256 should be long enough for any integer we're printing! */
String itodot(int x)
{
	/* assume that x is in network order. */
	char tmp[MAXTMP];
	int a,b,c,d;

	a = x & 0xff000000;
	b = x & 0x00ff0000;
	c = x & 0x0000ff00;
	d = x & 0x000000ff;

	sprintf(tmp, "%d.%d.%d.%d", a,b,c,d);
	String out(tmp);
	return out;
}

// itoa - same except pad it to a certain width with '0's.
String itoa(int x, int width, char pad)
{
	char tmp[MAXTMP];
	int i, l;

	if (width > MAXTMP) width = MAXTMP;

	sprintf(tmp, "%*d", width, x);

	l = strlen(tmp);
	for (i = 0; i < l; i++)
	{
		if (tmp[i] == ' ') tmp[i] = pad;
	}

	String out(tmp);
	return out;
}

String randomstr(int width)
{
    char tmp[width];
    memset(tmp, width, sizeof(char));

    String ret(tmp, width);

    for (int i = 0; i < width; i++)
    {
        ret[i] = (char)(random()%254 + 1);
    }
    return ret;
}

int split(String instr, String * outarr, int max, String sep)
{
    int i = -1, oldi = -1;
    int count = 0;

    while ((i = instr.find(sep, i+1)) != -1 && count < max)
    {
        outarr[count++] = instr.substr(oldi+1, i);
        oldi = i;
    }
    outarr[count++] =  instr.substr(oldi+1, instr.length());
    return count;
}

int gsub(String& str, const String& pat, const String& repl)
{
#ifdef FreeBSD
	return str.gsub(pat, repl);
#else
	int x = 0;
	int count = 0;

	while (x != -1)
	{
		x = str.find(pat, x+1);
		str.replace(x, pat.length(), repl);
		count++;
	}
	return count;
#endif
}


int reggsub(String& str, const String& regpat, const String& repl)
{
#ifdef FreeBSD
	Regex rstr = regpat.c_str();
	return str.gsub(rstr, repl);
#else
	int count = 0;
    int status;
	int len;
	int x = 0;
    regex_t   re;
	regmatch_t pmatch[1];
	const char * cstr;

    if (regcomp(&re, regpat.c_str(), REG_EXTENDED) != 0) 
	{
			/* report error? */
    		return(0);      
    }

	cstr = str.c_str();

	while (1)
	{
    	status = regexec(&re, &(cstr[x]), (size_t) 1, pmatch, 0);
    	if (status != 0) 
		{
    		break;
    	}
		if (pmatch[0].rm_so == -1) break;

		len = pmatch[0].rm_eo - pmatch[0].rm_so;
		str.replace(pmatch[0].rm_eo, len, repl);
		x = pmatch[0].rm_so + 1;
		count++;
	}

    regfree(&re);

    return count;
#endif
}

int regfind(const String& str, const String& pat)
{
    int status;
    regex_t   re;
	regmatch_t pmatch[1];
	const char * cstr;

    if (regcomp(&re, pat.c_str(), REG_EXTENDED) != 0) 
	{
			/* report error? */
    		return -1;      
    }

	cstr = str.c_str();
   	status = regexec(&re, cstr, (size_t) 1, pmatch, 0);
    if (status != 0) 
	{
   		return -1; 
    }

	return pmatch[0].rm_so;
}


#if 0
// Testing shit.
main()
{
	String x;

	x = itoa(7,2, ' ');

    printf("random:#%s#\n", randomstr(20).c_str());
}
#endif
