
//
// $Id: config.cc,v 1.5 2003/03/03 23:18:48 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/config.cc,v $
// $Revision: 1.5 $
// $Date: 2003/03/03 23:18:48 $
// $State: Exp $
//
// Author: Geoff Wong
// Configuration File for HammerHead2
//

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

/* for DNS resolutions */
/* #include <arpa/nameser.h> */
#include <resolv.h>

#include "str.h"
#include "reader.h"
#include "config.h"

#define MAX_LINE 256

/* configuration variables */
String ConfName = CONF_FILENAME;
/* a list of specific scenarios files to pull in */
list<String> ScenarioFiles;
/* a list of directories to serach */
list<String> ScenarioDirectories;
String HammerLog = HH_LOG;
String ReportLog = REPORT_LOG;
String RobotId;
String HTTPReqType = " HTTP/1.0";
list<HammerTarget> HammerTargets;
list<BottleNeck> BottleNecks;
list<long> IpAliases;
list<String> IpAliasPattern;
int DNSFirstTime = 1;
//int DNSTimeToLive = -1;
int DNSTimeToLive = 120; // default time to live...
int DNSTTLExpired = 1;
int UseSSLLayer = 0; // default to no ssl - can be individually controlled
					 // in scenario specifications.
int Sessions = SESSIONS;
int SelectOn = SO_SCN; /* select on scenarios */

int LogTimeFormat = TF_STRING;


char *SO_Names[] = {
                    "",
                    "scenario",
                    "sequence"
                  };

int CookieOn = 0;
int PrematureClose = 0;
int BadRequest = 0;
int ReportTime = REPORTTIME;

int Seed = SEED;
int SequenceProbability = SEQUENCEP;
int SleepTime = SLEEP;
int StartLag = STARTLAG;
int RunTime = RUNTIME;

int ThinkLimit = 60000000;
int LoadImages = 0;
int DoCrawl = 0;
String CrawlRE = "";
int SummaryInterval = 10;
int MaxFailures = MAXFAILURES;

int LogLevel = 0;

int ParseIPNumber(const char *a, int *al, int *ah) 
{
	char *dash;

	if (!a || !al || !ah) return -1;

	if (a[0] == '*') {
		*al = 1, *ah = 254;
	} else if ( (dash = strchr(a, '-' )) != NULL) {
		*dash = '\0';
		*al = atoi(a);
		*ah = atoi(dash+1);
	} else {
		*al = *ah = atoi(a);
	}

	return 0;
}

int OpenConfiguration()
{
    Reader r(ConfName);
    String tmp, p, n, u;
    String tmparr[2];
    

    if (r.eof() == true)
    {
        fprintf(stderr, "No configuration file found.\n");    
    }

    tmp = r.get_script_line();

    while (r.eof() == false)
    {
        split(tmp, tmparr, 2, " ");
        p = strip_whitespace(lowercase(tmparr[0]));
        n = topntail(lowercase(tmparr[1]));
        u = topntail(tmparr[1]);

        if (p == "scenario_directory") 
        {
			ScenarioDirectories.push_back(u);
        }
        else if (p == "http_request_type") 
        {
            // FIX: should check it's a valid request type!
            HTTPReqType = " " + n;
        }
        else if (p == "bad_request") 
        {
            BadRequest = atoi(n.c_str());
        }
        else if (p == "log_filename") 
        {
            HammerLog = u;
        }
		else if (p == "scenario_file")
		{
			ScenarioFiles.push_back(u);
		}
        else if (p == "report_time") 
        {
            ReportTime = atoi(n.c_str());
        }
        else if (p == "report_log") 
        {
            ReportLog = u;
        }
        else if (p == "robot_id") 
        {
            RobotId = u;
        }
        else if (p == "load_images") 
        {
            if (strip_whitespace(n) == "on")
            {
                LoadImages = 1;
            }
        }
        else if (p == "send_cookie") 
        {
            if (strip_whitespace(n) == "on")
            {
                CookieOn = 1;
            }
        }
        else if (p == "premature_close") 
        {
            PrematureClose = atoi(n.c_str());
        }
        else if (p == "log_level") 
        {
            LogLevel = atoi(n.c_str());
        }

        else if (p == "log_time_format") 
		{
            if (n == "numeric") 
            {
                LogTimeFormat = TF_NUMERIC;
            } 
			else if (n == "string") 
			{
				LogTimeFormat = TF_STRING;
			}
		}
		else if (p == "bandwidth_limit") 
		{
			/* place holder to control the read rate of
			   the session socket. TBA */
		}
        else if (p == "ip_alias") 
        {
                long addr;
				char buf[256];
				int  al, ah;
				int  bl, bh;
				int  cl, ch;
				int  dl, dh;
                String loc[4];

				/* this is handy - it stops us having to write
				   heaps of Ip_Alias entrys. May be any of; 

					a: 10.0.0.1
					b: 10.0.0.*
                    c: 10.0.*.*
					d: 10.0.1-5.*
					e: 10.0.0.1-5                         */

				/* parse the strings */
				fprintf(stderr, "found ip_alias: %s ", n.c_str());
				IpAliasPattern.push_front(n);

                split(n, loc, 4, ".");

				ParseIPNumber(loc[0].c_str(), &al, &ah);
				ParseIPNumber(loc[1].c_str(), &bl, &bh);
				ParseIPNumber(loc[2].c_str(), &cl, &ch);
				ParseIPNumber(loc[3].c_str(), &dl, &dh);

				/* push each IP address */
				fprintf(stderr, "...");
				for(int i = al; i < ah+1; i++) 
					for(int j = bl; j < bh+1; j++) 
						for(int k = cl; k < ch+1; k++) 
							for(int m = dl; m < dh+1; m++) {
								sprintf(buf, "%d.%d.%d.%d", i, j, k, m);
								addr = inet_addr(buf);
								IpAliases.push_front(addr);
							}
				fprintf(stderr, "\n");

        }
        else if (p == "crawl") 
        {
            DoCrawl = 1;

            // if we just want crawling on, assume we mean local
            // only, and set the default behaviour to do
            // that. Otherwise, user the regular expression...
            //
            if (n == "on")
            {
                CrawlRE = "/";
            }
            else
            {
                CrawlRE = n;
            }
        }
        else if (p == "run_time") 
        {
            RunTime = atoi(n.c_str());
        }
        else if (p == "seed") 
        {
            Seed = atoi(n.c_str());
        }
		else if (p == "selecton") 
		{
		    // decide what we what to do when we have gotten to
			// the end of a sequence.
			if (n == "scenario") 
			{
			    SelectOn = SO_SCN;
			}
			else if (n == "sequence") 
			{
			    SelectOn = SO_SEQ;
			}
			else
			{
			    fprintf(stderr, "Invalid SelectOn argument - ignoring.\n");
			}
		}
        else if (p == "sessions") 
        {
            Sessions = atoi(n.c_str());
        }
        else if (p == "sequence_probability") 
        {
            SequenceProbability = atoi(n.c_str());
        }
        else if (p == "sleep_time") 
        {
                // SleepTime must be in microseconds ... convert
                // from milliseconds
                SleepTime = atoi(n.c_str()) * 1000;
        }
		else if (p == "start_lag") 
		{
				// Start lag is delay at thread startup
				// before the first request in microseconds
				StartLag = atoi(n.c_str()) * 1000; // ms -> us
		}
        else if (p == "summary_interval") 
        {
            SummaryInterval = atoi(n.c_str());
        }
        else if (p == "dns_server") 
		{
				/* this is our prefered DNS server 
				   we will use this DNS server to resolve the
				   names of the machines to hammer. Otherwise
				   use whatever resolv.conf gives us.*/
				unsigned long DNSServer = 0;

				DNSServer = inet_addr(n.c_str());
				if (DNSServer == INADDR_NONE) 
				{
					DNSServer = 0;
					fprintf(stderr, "Bad DNS_Server Entry. (%s)\n", n.c_str());
                    tmp = r.get_script_line();
					continue;
				}

				/* 
					hack the DNS resolver structure 
				   	- stolen from dnsserver.c in squid 2.4 distribution 
				   	- likely to be FreeBSD specific. 
				*/
				
				if	(DNSFirstTime) {
					res_init();

					_res.options = RES_DEFAULT;
					_res.options &= ~RES_DEFNAMES;
					_res.options &= ~RES_DNSRCH;

					_res.nscount = 0;
					/* RES_INIT stops the reinitialization of _res */
					_res.options |= RES_INIT;

					DNSFirstTime = 0;
				}

				if (_res.nscount == MAXNS) {
					fprintf(stderr, "Too many DNS_Server entries, only %d are allowed.\n", MAXNS);
                    tmp = r.get_script_line();
					continue;
				}
			
				_res.nsaddr_list[_res.nscount] = _res.nsaddr_list[0];
				_res.nsaddr_list[_res.nscount++].sin_addr.s_addr = DNSServer;
        }
        else if (p == "dns_ttl") 
		{
		    /* setting this will cause the TTL for dns	
			    resolutions to be ignored and this value to be used */

			DNSTimeToLive = atoi(n.c_str());
        }
        else if (p == "machine_ip") 
        {
            unsigned long addr;
			HammerTarget target;
            String loc[2];

            target.HammerIP = n;
			target.HammerPort = HAMMER_PORT;
			target.SSLPort = SSL_PORT;
			target.DoDNSLookups = 0;

            split(n, loc, 2, ":");
            target.HammerPort = atoi(loc[1].c_str());

            /* in network order. */
            addr = inet_addr(loc[0].c_str());
			if (addr == INADDR_NONE)
            {
                    fprintf(stderr, "Bad Machine_IP Entry. (%s)\n", loc[0].c_str());
            }

            target.HammerMachine = addr;
			HammerTargets.push_front(target);
        }
        else if (p == "machine_name") 
        {
				/* Specify the name of the machine to hammer.
				   This requires a DNS lookup - see the DNS
				   config options. */

		    HammerTarget target;
			struct hostent *host;
			struct in_addr addr;
            String loc[2];

            target.HammerIP = n;
			target.HammerPort = HAMMER_PORT;
			target.SSLPort = SSL_PORT;

            split(n, loc, 2, ":");
            target.HammerPort = atoi(loc[1].c_str());
			target.HammerName = loc[0];

			/* we'll want to resolv this one in each session. */
			target.DoDNSLookups = 1;

			/* 
					check that we get an answer back. 
					- the ordering of a DNS_Server and
					  Machine_Name directives is *important*. 
			*/
			host = gethostbyname(loc[0].c_str());
            if (host == NULL)
            {
                fprintf(stderr, "Unable to resolve Machine_Name Entry. (%s) Check DNS_Server lines before this line.\n", loc[0].c_str());
                tmp = r.get_script_line();
				continue;
            }

			memcpy(&addr, host->h_addr, sizeof(addr));
			fprintf(stderr, "Found %s for %s.\n", inet_ntoa(addr), loc[0].c_str());

            target.HammerIP = inet_ntoa(addr);
			target.HammerMachine = addr.s_addr;

			HammerTargets.push_front(target);
        }
        else if (p == "use_ssl") 
		{
		    /* we are going to turn on the use of SSL */
            if (n == "on") 
            {
			    UseSSLLayer = 1;
            } 
			else 
			{
			    UseSSLLayer = 0;
		    }

#ifndef HAVE_SSL
			UseSSLLayer = 0;
			    fprintf(stderr, "SSL not compiled in. Ignoring directive.\n");
#endif
		}
        else if (p == "max_failures") 
		{
		    /* the maximum number of failures we will tolerate
			before giving upon a test. 0 means never stop.*/

			MaxFailures = atoi(n.c_str());

			if (MaxFailures < 0) MaxFailures = 0;
		}
        else if (p == "bottleneck") 
        {
		    BottleNeck bn;
			String dist;
            String loc[5];
            int t;

			/* client bottleneck simulation */

			/* syntax:
			    BottleNeck <name> <distribution type> <probability> <paramaters> 
			    note: variable number of ditribution parameters.

				Currently this does extend beyond this configuration code
				due to implementation problems...
		    */

            t = split(n, loc, 5, " ");

            /* get the name */
			bn.Name = loc[0]; 
            dist = lowercase(loc[1]); 

			/* get the probability */
			bn.probability = atof(loc[2].c_str());

			if (dist == "uniform") 
			{
				/* we're dealing with a uniform distribution */
				float s;

                /* get the size */
				s = atof(loc[3].c_str());

				bn.type = new Uniform(s);
		    }
			else if (dist == "normal") 
			{
				/* we're dealing with a normal distribution */
				float m, v;

				m = atof(loc[3].c_str()); /* get the mean */
				v = atof(loc[4].c_str()); /* get get the variance */

				bn.type = new Normal(m,v);
			}
			else if (dist == "exponential") 
			{
			    /* we're dealing with a exponential distribution */
				float m, v;

				m = atof(loc[3].c_str()); /* get the mean */
				v = atof(loc[4].c_str()); /* get get the variance */

				bn.type = new Exponential(m,v);
			}
			else
			{
					fprintf(stderr, "Unknown distribution in BottleNeck line - %s\n", dist.c_str());
                    tmp = r.get_script_line();
					continue;
			}

			BottleNecks.push_front(bn);

        }
		else
		{
            if (p.empty() == false)
	            fprintf(stderr, "Unknown configuration directive (%s: %s).\n", p.c_str(), n.c_str());
		}

        tmp = r.get_script_line();
    }

    return 1;
}

