// Copyright (C) 2000-2003, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget, or send a mail to
// <luca.padovani@cs.unibo.it>

// WARNING: do not edit! This file has been generated automatically


#include <Char.hh>

  
typedef struct TableEntry
{
  Char16 normal;
  Char32 variant;
} TableEntry;

static TableEntry table[] =
{
  { 0x00030, 0x1D7EC }, 
  { 0x00031, 0x1D7ED }, 
  { 0x00032, 0x1D7EE }, 
  { 0x00033, 0x1D7EF }, 
  { 0x00034, 0x1D7F0 }, 
  { 0x00035, 0x1D7F1 }, 
  { 0x00036, 0x1D7F2 }, 
  { 0x00037, 0x1D7F3 }, 
  { 0x00038, 0x1D7F4 }, 
  { 0x00039, 0x1D7F5 }, 
  { 0x00041, 0x1D5D4 }, 
  { 0x00042, 0x1D5D5 }, 
  { 0x00043, 0x1D5D6 }, 
  { 0x00044, 0x1D5D7 }, 
  { 0x00045, 0x1D5D8 }, 
  { 0x00046, 0x1D5D9 }, 
  { 0x00047, 0x1D5DA }, 
  { 0x00048, 0x1D5DB }, 
  { 0x00049, 0x1D5DC }, 
  { 0x0004A, 0x1D5DD }, 
  { 0x0004B, 0x1D5DE }, 
  { 0x0004C, 0x1D5DF }, 
  { 0x0004D, 0x1D5E0 }, 
  { 0x0004E, 0x1D5E1 }, 
  { 0x0004F, 0x1D5E2 }, 
  { 0x00050, 0x1D5E3 }, 
  { 0x00051, 0x1D5E4 }, 
  { 0x00052, 0x1D5E5 }, 
  { 0x00053, 0x1D5E6 }, 
  { 0x00054, 0x1D5E7 }, 
  { 0x00055, 0x1D5E8 }, 
  { 0x00056, 0x1D5E9 }, 
  { 0x00057, 0x1D5EA }, 
  { 0x00058, 0x1D5EB }, 
  { 0x00059, 0x1D5EC }, 
  { 0x0005A, 0x1D5ED }, 
  { 0x00061, 0x1D5EE }, 
  { 0x00062, 0x1D5EF }, 
  { 0x00063, 0x1D5F0 }, 
  { 0x00064, 0x1D5F1 }, 
  { 0x00065, 0x1D5F2 }, 
  { 0x00066, 0x1D5F3 }, 
  { 0x00067, 0x1D5F4 }, 
  { 0x00068, 0x1D5F5 }, 
  { 0x00069, 0x1D5F6 }, 
  { 0x0006A, 0x1D5F7 }, 
  { 0x0006B, 0x1D5F8 }, 
  { 0x0006C, 0x1D5F9 }, 
  { 0x0006D, 0x1D5FA }, 
  { 0x0006E, 0x1D5FB }, 
  { 0x0006F, 0x1D5FC }, 
  { 0x00070, 0x1D5FD }, 
  { 0x00071, 0x1D5FE }, 
  { 0x00072, 0x1D5FF }, 
  { 0x00073, 0x1D600 }, 
  { 0x00074, 0x1D601 }, 
  { 0x00075, 0x1D602 }, 
  { 0x00076, 0x1D603 }, 
  { 0x00077, 0x1D604 }, 
  { 0x00078, 0x1D605 }, 
  { 0x00079, 0x1D606 }, 
  { 0x0007A, 0x1D607 }, 
  { 0x00391, 0x1D756 }, 
  { 0x00392, 0x1D757 }, 
  { 0x00393, 0x1D758 }, 
  { 0x00394, 0x1D759 }, 
  { 0x00395, 0x1D75A }, 
  { 0x00396, 0x1D75B }, 
  { 0x00397, 0x1D75C }, 
  { 0x00398, 0x1D75D }, 
  { 0x00399, 0x1D75E }, 
  { 0x0039A, 0x1D75F }, 
  { 0x0039B, 0x1D760 }, 
  { 0x0039C, 0x1D761 }, 
  { 0x0039D, 0x1D762 }, 
  { 0x0039E, 0x1D763 }, 
  { 0x0039F, 0x1D764 }, 
  { 0x003A0, 0x1D765 }, 
  { 0x003A1, 0x1D766 }, 
  { 0x003A3, 0x1D768 }, 
  { 0x003A4, 0x1D769 }, 
  { 0x003A5, 0x1D76A }, 
  { 0x003A6, 0x1D76B }, 
  { 0x003A7, 0x1D76C }, 
  { 0x003A8, 0x1D76D }, 
  { 0x003A9, 0x1D76E }, 
  { 0x003B1, 0x1D770 }, 
  { 0x003B2, 0x1D771 }, 
  { 0x003B3, 0x1D772 }, 
  { 0x003B4, 0x1D773 }, 
  { 0x003B5, 0x1D774 }, 
  { 0x003B6, 0x1D775 }, 
  { 0x003B7, 0x1D776 }, 
  { 0x003B8, 0x1D777 }, 
  { 0x003B9, 0x1D778 }, 
  { 0x003BA, 0x1D779 }, 
  { 0x003BB, 0x1D77A }, 
  { 0x003BC, 0x1D77B }, 
  { 0x003BD, 0x1D77C }, 
  { 0x003BE, 0x1D77D }, 
  { 0x003BF, 0x1D77E }, 
  { 0x003C0, 0x1D77F }, 
  { 0x003C1, 0x1D780 }, 
  { 0x003C2, 0x1D781 }, 
  { 0x003C3, 0x1D782 }, 
  { 0x003C4, 0x1D783 }, 
  { 0x003C5, 0x1D784 }, 
  { 0x003C6, 0x1D785 }, 
  { 0x003C7, 0x1D786 }, 
  { 0x003C8, 0x1D787 }, 
  { 0x003C9, 0x1D788 }, 
  { 0x003D1, 0x1D78B }, 
  { 0x003D5, 0x1D78D }, 
  { 0x003D6, 0x1D78F }, 
  { 0x003F0, 0x1D78C }, 
  { 0x003F1, 0x1D78E }, 
  { 0x003F4, 0x1D767 }, 
  { 0x02202, 0x1D789 }, 
  { 0x02207, 0x1D76F }, 
  { 0x0220A, 0x1D78A }, 
  { 0, 0 }
};

Char32 
map_variant_bold_sans_serif
(Char32 ch)
{
  if (ch >= 0x0030 and ch < 0x0039) return table[ch - 0x0030].variant;
  if (ch >= 0x0041 and ch < 0x005A) return table[ch - 0x0037].variant;
  if (ch >= 0x0061 and ch < 0x007A) return table[ch - 0x003D].variant;
  if (ch >= 0x0391 and ch < 0x03A1) return table[ch - 0x0353].variant;
  if (ch >= 0x03A3 and ch < 0x03A9) return table[ch - 0x0354].variant;
  if (ch >= 0x03B1 and ch < 0x03C9) return table[ch - 0x035B].variant;
  if (ch == 0x03D1) return 0x1D78B;
  if (ch >= 0x03D5 and ch < 0x03D6) return table[ch - 0x0365].variant;
  if (ch >= 0x03F0 and ch < 0x03F1) return table[ch - 0x037E].variant;
  if (ch == 0x03F4) return 0x1D767;
  if (ch == 0x2202) return 0x1D789;
  if (ch == 0x2207) return 0x1D76F;
  if (ch == 0x220A) return 0x1D78A;
  return ch;
}
