/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#define HORIZONTAL 0
#define VERTICAL   1

/* Pixmaps */
void widget_pixmap_set_color (GtkWidget *pixmap, GdkWindow *window,
			      gint width, gint height,
			      const gdouble *color);
GtkWidget *widget_pixmap_create_from_color (GdkWindow *window, gint width,
					    gint height, const gdouble *color);
GtkWidget *widget_pixmap_create_from_data (GdkWindow *window, gchar **icon);

/* Buttons */
GtkWidget *widget_button_add (GtkWidget *box, gint expand, const gchar *title);
GtkWidget *widget_button_color_add (GtkWidget *box, GdkWindow *window,
				    gdouble *color, const gchar *title);

/* Separators */
void widget_vhseparator_add (GtkWidget *box, gint orientation);

/* Menus */
GtkWidget *widget_menu_add (GtkWidget *item);
GtkWidget *widget_menu_item_add (GtkWidget *menu, const gchar *title);

/* Frames */
GtkWidget *widget_frame_add (GtkWidget *box, const gchar *title);

/* Scales */
//gboolean widget_scale_changed (GtkAdjustment *adj, gint *value);
GtkWidget *widget_scale_add (GtkWidget *box, gint *value, const gchar *title);

/* Checks */
void widget_check_clicked (GtkWidget *button, gint *value);
GtkWidget *widget_check_add (GtkWidget *box, gint *value, const gchar *title);

/* Spins */
void widget_spin_float_changed (GtkSpinButton *spin);
GtkWidget *widget_spin_add_float (GtkWidget *box, gfloat *value,
				  gfloat max, gfloat min, gfloat step,
				  const gchar *title);
void widget_spin_int_changed (GtkSpinButton *spin);
GtkWidget *widget_spin_add_int (GtkWidget *box, gint *value,
				gint max, gint min, gint step,
				const gchar *title);

/* Radios */
void widget_radio_clicked (GtkWidget *button, gint val);
GtkWidget *widget_radio_add (GtkWidget *box, GtkWidget *from,
			     gint val, gint *value,
			     const gchar *title);

/* Entrys */
GtkWidget *widget_entry_add_float (GtkWidget *box, gfloat *value,
				   gint max_char, const gchar *title);
GtkWidget *widget_entry_add_int (GtkWidget *box, gint *value,
				 gint max_char, const gchar *title);
GtkWidget *widget_entry_add_chars (GtkWidget *box, gchar **value,
				   gint max_char, const gchar *title);

void widget_entry_get_chars (GtkWidget *entry, gchar *text[]);
gint widget_entry_get_int (GtkWidget *entry);
gfloat widget_entry_get_float (GtkWidget *entry);

/* All */
void widget_set_sensitivity_invert (GtkWidget *widget);
