/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include <locale.h>
#include <gnome.h>
#include <glade/glade.h>
#include <gst/gst.h>

#include <gst/editor/editor.h>


int
main (int argc, char *argv[])
{
  GstEditor *editor;
  GnomeProgram *p;
  gboolean launch = FALSE;
  struct poptOption options[] = {
    {NULL, '\0', POPT_ARG_INCLUDE_TABLE, NULL, 0, "Help options:", NULL},
    {"launch", 'l', POPT_ARG_NONE | POPT_ARGFLAG_STRIP, &launch, 0,
        "Create pipeline from gst-launch(1) syntax", NULL},
    POPT_TABLEEND
  };
  poptContext context;
  const gchar **argvn;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  g_type_init ();
  glade_init ();
  //gst_scheduler_factory_set_default_name ("basicwingo");
  options[0].arg = (void *) gst_init_get_popt_table ();
  if (!(p = gnome_program_init (PACKAGE, VERSION,
              LIBGNOMEUI_MODULE,
              argc, argv,
              GNOME_PARAM_POPT_TABLE, options,
              GNOME_PARAM_APP_DATADIR, DATADIR,
              "app-datadir", GST_EDITOR_DATA_DIR, NULL)))
    g_error ("gnome_progam_init() failed, aborting...");

  g_object_get (p, "popt-context", &context, NULL);
  argvn = poptGetArgs (context);
  
  gste_init ();

  if (argvn) {
    if (launch) {
      GError *error = NULL;
      GstElement *element;
      GstBin *bin;

      element = gst_parse_launchv (argvn, &error);
      if (!element) {
        g_print ("Error: %s\n", error->message);
        exit (1);
      }
      bin = GST_BIN (element);
      editor = (GstEditor *) gst_editor_new (GST_ELEMENT (bin));
    } else {
      while (*argvn) {
        editor = (GstEditor *) gst_editor_new (NULL);
        gst_editor_load (editor, *argvn++);
      }
    }
  } else {
    gst_editor_new (gst_element_factory_make ("pipeline", NULL));
  }

  gtk_main ();

  exit (0);
}
